/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.drools;

import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.common.domain.AbstractPersistable;

public class IdleCost
implements Comparable<IdleCost> {
    private static final Comparator<IdleCost> COMPARATOR = Comparator.comparing(IdleCost::getMachine, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingInt(IdleCost::getActivePeriodAfterIdle).thenComparingLong(IdleCost::getCost);
    private final Machine machine;
    private final int activePeriodAfterIdle;
    private final long cost;

    public IdleCost(Machine machine, int activePeriodAfterIdle, long cost) {
        this.machine = machine;
        this.activePeriodAfterIdle = activePeriodAfterIdle;
        this.cost = cost;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public int getActivePeriodAfterIdle() {
        return this.activePeriodAfterIdle;
    }

    public long getCost() {
        return this.cost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IdleCost) {
            IdleCost other = (IdleCost)o;
            return new EqualsBuilder().append((Object)this.machine, (Object)other.machine).append(this.activePeriodAfterIdle, other.activePeriodAfterIdle).append(this.cost, other.cost).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.machine).append(this.activePeriodAfterIdle).append(this.cost).toHashCode();
    }

    @Override
    public int compareTo(IdleCost other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return "machine = " + this.machine + ", activePeriodAfterIdle = " + this.activePeriodAfterIdle + ", cost = " + this.cost;
    }
}

