/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsFilterQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsJoinQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsScoringQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.quad.InnerQuadConstraintStream;

public abstract class DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerQuadConstraintStream<A, B, C, D> {
    protected final DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent;

    public DroolsAbstractQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D> parent) {
        super(constraintFactory);
        if (parent == null && !(this instanceof DroolsJoinQuadConstraintStream)) {
            throw new IllegalArgumentException("The stream (" + this + ") must have a parent (null), unless it's a join stream.");
        }
        this.parent = parent;
    }

    @Override
    public QuadConstraintStream<A, B, C, D> filter(QuadPredicate<A, B, C, D> predicate) {
        DroolsFilterQuadConstraintStream stream = new DroolsFilterQuadConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    protected Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    protected Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        if (this.parent == null) {
            DroolsJoinQuadConstraintStream joinStream = (DroolsJoinQuadConstraintStream)this;
            List leftParentFromStreamList = joinStream.getLeftParentStream().getFromStreamList();
            List rightParentFromStreamList = joinStream.getRightParentStream().getFromStreamList();
            return Stream.concat(leftParentFromStreamList.stream(), rightParentFromStreamList.stream()).collect(Collectors.toList());
        }
        return this.parent.getFromStreamList();
    }

    public abstract DroolsQuadCondition<A, B, C, D> getCondition();
}

