/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.lang.reflect.Type;
import java.util.Optional;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.util.CoercionUtils;

public class MapPutExprT
implements TypedExpression {
    private final TypedExpression name;
    private final Expression key;
    private final TypedExpression value;
    private final Optional<Type> type;

    public MapPutExprT(TypedExpression name, Expression key, TypedExpression value, Optional<Type> type) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.type = type;
    }

    @Override
    public Optional<Type> getType() {
        return Optional.empty();
    }

    @Override
    public Node toJavaExpression() {
        Expression originalValue = (Expression)this.value.toJavaExpression();
        Expression coercedValue = CoercionUtils.coerceMapValueToString(this.type, originalValue);
        return new MethodCallExpr((Expression)this.name.toJavaExpression(), "put", NodeList.nodeList((Node[])new Expression[]{this.key, coercedValue}));
    }
}

