/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.stream;

import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;

public class ConstraintStreamScoreDirectorFactory<Solution_>
extends AbstractScoreDirectorFactory<Solution_> {
    private final ConstraintSessionFactory<Solution_> constraintSessionFactory;

    public ConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, ConstraintStreamImplType constraintStreamImplType) {
        super(solutionDescriptor);
        InnerConstraintFactory<Solution_> constraintFactory;
        switch (constraintStreamImplType) {
            case BAVET: {
                constraintFactory = new BavetConstraintFactory<Solution_>(solutionDescriptor);
                break;
            }
            case DROOLS: {
                constraintFactory = new DroolsConstraintFactory<Solution_>(solutionDescriptor);
                break;
            }
            default: {
                throw new IllegalStateException("The constraintStreamImplType (" + (Object)((Object)constraintStreamImplType) + ") is not implemented.");
            }
        }
        Constraint[] constraints = constraintProvider.defineConstraints(constraintFactory);
        this.constraintSessionFactory = constraintFactory.buildSessionFactory(constraints);
    }

    @Override
    public ConstraintStreamScoreDirector<Solution_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        return new ConstraintStreamScoreDirector(this, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public ConstraintSession<Solution_> newConstraintStreamingSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        return this.constraintSessionFactory.buildSession(constraintMatchEnabled, workingSolution);
    }
}

