/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class HardSoftBigDecimalScoreInliner
extends ScoreInliner<HardSoftBigDecimalScore> {
    protected BigDecimal hardScore = BigDecimal.ZERO;
    protected BigDecimal softScore = BigDecimal.ZERO;

    protected HardSoftBigDecimalScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimalWeightedScoreImpacter buildWeightedScoreImpacter(HardSoftBigDecimalScore constraintWeight) {
        if (constraintWeight.equals(HardSoftBigDecimalScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        BigDecimal hardConstraintWeight = constraintWeight.getHardScore();
        BigDecimal softConstraintWeight = constraintWeight.getSoftScore();
        if (softConstraintWeight.equals(BigDecimal.ZERO)) {
            return (matchWeight, matchScoreConsumer) -> {
                BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
                this.hardScore = this.hardScore.add(hardImpact);
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardSoftBigDecimalScore.ofHard(hardImpact));
                }
                return () -> {
                    this.hardScore = this.hardScore.subtract(hardImpact);
                };
            };
        }
        if (hardConstraintWeight.equals(BigDecimal.ZERO)) {
            return (matchWeight, matchScoreConsumer) -> {
                BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
                this.softScore = this.softScore.add(softImpact);
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardSoftBigDecimalScore.ofSoft(softImpact));
                }
                return () -> {
                    this.softScore = this.softScore.subtract(softImpact);
                };
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
            BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
            this.hardScore = this.hardScore.add(hardImpact);
            this.softScore = this.softScore.add(softImpact);
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(HardSoftBigDecimalScore.of(hardImpact, softImpact));
            }
            return () -> {
                this.hardScore = this.hardScore.subtract(hardImpact);
                this.softScore = this.softScore.subtract(softImpact);
            };
        };
    }

    @Override
    public HardSoftBigDecimalScore extractScore(int initScore) {
        return HardSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

