/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.management;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.management.GenericKieSessionMonitoringImpl;
import org.drools.core.management.KieSessionMonitoringImpl;
import org.drools.core.management.KnowledgeBaseMonitoring;
import org.drools.core.management.StatelessKieSessionMonitoringImpl;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.management.KieManagementAgentMBean;
import org.kie.internal.runtime.StatelessKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsManagementAgent
implements KieManagementAgentMBean {
    private static final String CONTAINER_NAME_PREFIX = "org.kie";
    private static DroolsManagementAgent INSTANCE;
    private static MBeanServer mbs;
    protected static final transient Logger logger;
    private long kbases = 0L;
    private long ksessions = 0L;
    private Map<Object, List<ObjectName>> mbeans;
    private Map<Object, Object> mbeansRefs = new HashMap<Object, Object>();

    private DroolsManagementAgent() {
        this.mbeans = new HashMap<Object, List<ObjectName>>();
    }

    public static synchronized DroolsManagementAgent getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DroolsManagementAgent();
        }
        return INSTANCE;
    }

    public static ObjectName createObjectNameFor(InternalKnowledgeBase kbase) {
        return DroolsManagementAgent.createObjectName(DroolsManagementAgent.createObjectNameBy(kbase.getContainerId()) + ",kbaseId=" + ObjectName.quote(kbase.getId()));
    }

    public static ObjectName createObjectNameFor(InternalWorkingMemory ksession) {
        return DroolsManagementAgent.createObjectName(DroolsManagementAgent.createObjectNameFor(ksession.getKnowledgeBase()) + ",group=Sessions,ksessionId=Session-" + ksession.getIdentifier());
    }

    public static ObjectName createObjectNameBy(String containerId) {
        return DroolsManagementAgent.createObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId));
    }

    public static ObjectName createObjectNameBy(String containerId, String kbaseId, KieSessionModel.KieSessionType ksessionType, String ksessionName) {
        return DroolsManagementAgent.createObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",kbaseId=" + ObjectName.quote(kbaseId) + ",ksessionType=" + DroolsManagementAgent.ksessionType(ksessionType) + ",ksessionName=" + ObjectName.quote(ksessionName));
    }

    private static String ksessionType(KieSessionModel.KieSessionType ksessionType) {
        switch (ksessionType) {
            case STATELESS: {
                return "Stateless";
            }
        }
        return "Stateful";
    }

    public synchronized long getKieBaseCount() {
        return this.kbases;
    }

    public synchronized long getSessionCount() {
        return this.ksessions;
    }

    public synchronized long getNextKnowledgeBaseId() {
        return ++this.kbases;
    }

    public synchronized long getNextKnowledgeSessionId() {
        return ++this.ksessions;
    }

    public void registerKnowledgeBase(InternalKnowledgeBase kbase) {
        KnowledgeBaseMonitoring mbean = new KnowledgeBaseMonitoring(kbase);
        this.registerMBean(kbase, mbean, mbean.getName());
    }

    public void unregisterKnowledgeBase(InternalKnowledgeBase kbase) {
        this.unregisterMBeansFromOwner(kbase);
    }

    public void registerKnowledgeSessionUnderName(CBSKey cbsKey, KieRuntimeEventManager ksession) {
        GenericKieSessionMonitoringImpl bean = this.getKnowledgeSessionBean(cbsKey, ksession);
        if (bean != null) {
            bean.attach(ksession);
        }
    }

    public void unregisterKnowledgeSessionUnderName(CBSKey cbsKey, KieRuntimeEventManager ksession) {
        GenericKieSessionMonitoringImpl bean = this.getKnowledgeSessionBean(cbsKey, ksession);
        if (bean != null) {
            bean.detach(ksession);
        }
    }

    public void unregisterKnowledgeSessionBean(CBSKey cbsKey) {
        this.unregisterMBeansFromOwner(cbsKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericKieSessionMonitoringImpl getKnowledgeSessionBean(CBSKey cbsKey, KieRuntimeEventManager ksession) {
        if (this.mbeansRefs.get(cbsKey) != null) {
            return (GenericKieSessionMonitoringImpl)this.mbeansRefs.get(cbsKey);
        }
        if (ksession instanceof StatelessKnowledgeSession) {
            Map<Object, Object> map = this.mbeansRefs;
            synchronized (map) {
                if (this.mbeansRefs.get(cbsKey) != null) {
                    return (GenericKieSessionMonitoringImpl)this.mbeansRefs.get(cbsKey);
                }
                try {
                    StatelessKieSessionMonitoringImpl mbean = new StatelessKieSessionMonitoringImpl(cbsKey.kcontainerId, cbsKey.kbaseId, cbsKey.ksessionName);
                    this.registerMBean(cbsKey, mbean, mbean.getName());
                    this.mbeansRefs.put(cbsKey, mbean);
                    return mbean;
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate and register StatelessKieSessionMonitoringMBean");
                    return null;
                }
            }
        }
        Map<Object, Object> map = this.mbeansRefs;
        synchronized (map) {
            if (this.mbeansRefs.get(cbsKey) != null) {
                return (GenericKieSessionMonitoringImpl)this.mbeansRefs.get(cbsKey);
            }
            try {
                KieSessionMonitoringImpl mbean = new KieSessionMonitoringImpl(cbsKey.kcontainerId, cbsKey.kbaseId, cbsKey.ksessionName);
                this.registerMBean(cbsKey, mbean, mbean.getName());
                this.mbeansRefs.put(cbsKey, mbean);
                return mbean;
            }
            catch (Exception e) {
                logger.error("Unable to instantiate and register (stateful) KieSessionMonitoringMBean");
                return null;
            }
        }
    }

    public void registerMBean(Object owner, Object mbean, ObjectName name) {
        try {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(mbean, name);
                List<ObjectName> mbl = this.mbeans.get(owner);
                if (mbl == null) {
                    mbl = new LinkedList<ObjectName>();
                    this.mbeans.put(owner, mbl);
                    if (mbean instanceof StandardMBean) {
                        this.mbeansRefs.put(owner, ((StandardMBean)mbean).getImplementation());
                    } else {
                        this.mbeansRefs.put(owner, mbean);
                    }
                }
                mbl.add(name);
                logger.debug("Registered {} into the platform MBean Server", (Object)name);
            }
        }
        catch (Exception e) {
            logger.error("Unable to register mbean " + name + " into the platform MBean Server", (Throwable)e);
        }
    }

    public void unregisterMBeansFromOwner(Object owner) {
        List<ObjectName> mbl = this.mbeans.remove(owner);
        this.mbeansRefs.remove(owner);
        if (mbl != null) {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            for (ObjectName name : mbl) {
                this.unregisterMBeanFromServer(mbs, name);
            }
        }
    }

    private void unregisterMBeanFromServer(MBeanServer mbs, ObjectName name) {
        try {
            mbs.unregisterMBean(name);
            logger.debug("Unregistered from MBean Server: {}", (Object)name);
        }
        catch (Exception e) {
            logger.error("Exception unregistering mbean: " + name, (Throwable)e);
        }
    }

    public void unregisterMBean(Object owner, ObjectName mbean) {
        List<ObjectName> mbl = this.mbeans.get(owner);
        if (mbl != null) {
            mbl.remove(mbean);
        }
        MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
        this.unregisterMBeanFromServer(mbs, mbean);
    }

    public void unregisterDependentsMBeansFromOwner(Object owner) {
        List<ObjectName> mbl = this.mbeans.get(owner);
        if (mbl != null) {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            for (ObjectName name : mbl.subList(1, mbl.size())) {
                this.unregisterMBeanFromServer(mbs, name);
            }
            mbl.subList(1, mbl.size()).clear();
        }
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            logger.error("This is a bug. Error creating ObjectName for MBean: " + name + "\nPlease contact the development team and provide the following stack trace: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static MBeanServer getMBeanServer() {
        if (mbs == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return mbs;
    }

    static {
        logger = LoggerFactory.getLogger(DroolsManagementAgent.class);
    }

    public static class CBSKey {
        private final String kcontainerId;
        private final String kbaseId;
        private final String ksessionName;

        public CBSKey(String kcontainerId, String kbaseId, String ksessionName) {
            this.kcontainerId = kcontainerId;
            this.kbaseId = kbaseId;
            this.ksessionName = ksessionName;
        }

        public String getKcontainerId() {
            return this.kcontainerId;
        }

        public String getKbaseId() {
            return this.kbaseId;
        }

        public String getKsessionName() {
            return this.ksessionName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kbaseId == null ? 0 : this.kbaseId.hashCode());
            result = 31 * result + (this.kcontainerId == null ? 0 : this.kcontainerId.hashCode());
            result = 31 * result + (this.ksessionName == null ? 0 : this.ksessionName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CBSKey)) {
                return false;
            }
            CBSKey other = (CBSKey)obj;
            if (this.kbaseId == null ? other.kbaseId != null : !this.kbaseId.equals(other.kbaseId)) {
                return false;
            }
            if (this.kcontainerId == null ? other.kcontainerId != null : !this.kcontainerId.equals(other.kcontainerId)) {
                return false;
            }
            return !(this.ksessionName == null ? other.ksessionName != null : !this.ksessionName.equals(other.ksessionName));
        }

        public String toString() {
            return "CBSKey [kcontainerId=" + this.kcontainerId + ", kbaseId=" + this.kbaseId + ", ksessionName=" + this.ksessionName + "]";
        }
    }
}

