/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.SlidingTimeWindow;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.internal.marshalling.MarshallerFactory;

public class MarshallerWriteContext
extends ObjectOutputStream {
    public final MarshallerWriteContext stream;
    public final InternalKnowledgeBase kBase;
    public final InternalWorkingMemory wm;
    public final Map<Integer, BaseNode> sinks;
    public long clockTime;
    public final Map<Class<?>, TimersOutputMarshaller> writersByClass;
    public final PrintStream out = System.out;
    public final ObjectMarshallingStrategyStore objectMarshallingStrategyStore;
    public final Map<ObjectMarshallingStrategy, Integer> usedStrategies;
    public final Map<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context> strategyContext;
    public final Map<LeftTuple, Integer> terminalTupleMap;
    public final boolean marshalProcessInstances;
    public final boolean marshalWorkItems;
    public final Environment env;
    public Object parameterObject;

    public MarshallerWriteContext(OutputStream stream, InternalKnowledgeBase kBase, InternalWorkingMemory wm, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, Environment env) throws IOException {
        this(stream, kBase, wm, sinks, resolverStrategyFactory, true, true, env);
    }

    public MarshallerWriteContext(OutputStream stream, InternalKnowledgeBase kBase, InternalWorkingMemory wm, Map<Integer, BaseNode> sinks, ObjectMarshallingStrategyStore resolverStrategyFactory, boolean marshalProcessInstances, boolean marshalWorkItems, Environment env) throws IOException {
        super(stream);
        this.stream = this;
        this.kBase = kBase;
        this.wm = wm;
        this.sinks = sinks;
        this.writersByClass = new HashMap();
        this.writersByClass.put(SlidingTimeWindow.BehaviorJobContext.class, new SlidingTimeWindow.BehaviorJobContextTimerOutputMarshaller());
        this.writersByClass.put(ObjectTypeNode.ExpireJobContext.class, new ObjectTypeNode.ExpireJobContextTimerOutputMarshaller());
        this.writersByClass.put(PhreakTimerNode.TimerNodeJobContext.class, new PhreakTimerNode.TimerNodeTimerOutputMarshaller());
        if (resolverStrategyFactory == null) {
            ObjectMarshallingStrategy[] strats = (ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
            if (strats == null) {
                strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
            }
            this.objectMarshallingStrategyStore = new ObjectMarshallingStrategyStoreImpl(strats);
        } else {
            this.objectMarshallingStrategyStore = resolverStrategyFactory;
        }
        this.usedStrategies = new HashMap<ObjectMarshallingStrategy, Integer>();
        this.strategyContext = new HashMap<ObjectMarshallingStrategy, ObjectMarshallingStrategy.Context>();
        this.terminalTupleMap = new IdentityHashMap<LeftTuple, Integer>();
        this.marshalProcessInstances = marshalProcessInstances;
        this.marshalWorkItems = marshalWorkItems;
        this.env = env;
    }

    public Integer getStrategyIndex(ObjectMarshallingStrategy strategy) {
        Integer index = this.usedStrategies.get(strategy);
        if (index == null) {
            index = this.usedStrategies.size();
            this.usedStrategies.put(strategy, index);
            this.strategyContext.put(strategy, strategy.createContext());
        }
        return index;
    }
}

