/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.partitionedsearch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.recaller.BestSolutionRecallerConfig;
import org.optaplanner.core.impl.partitionedsearch.PartitionSolver;
import org.optaplanner.core.impl.partitionedsearch.PartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.event.PartitionedSearchPhaseLifecycleListener;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.partitionedsearch.queue.PartitionQueue;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionChangeMove;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionedSearchPhaseScope;
import org.optaplanner.core.impl.partitionedsearch.scope.PartitionedSearchStepScope;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.ChildThreadPlumbingTermination;
import org.optaplanner.core.impl.solver.termination.OrCompositeTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultPartitionedSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements PartitionedSearchPhase<Solution_>,
PartitionedSearchPhaseLifecycleListener<Solution_> {
    protected SolutionPartitioner<Solution_> solutionPartitioner;
    protected ThreadFactory threadFactory;
    protected Integer runnablePartThreadLimit;
    protected List<PhaseConfig> phaseConfigList;
    protected HeuristicConfigPolicy configPolicy;

    public DefaultPartitionedSearchPhase(int phaseIndex, String logIndentation, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination termination) {
        super(phaseIndex, logIndentation, bestSolutionRecaller, termination);
    }

    public void setSolutionPartitioner(SolutionPartitioner<Solution_> solutionPartitioner) {
        this.solutionPartitioner = solutionPartitioner;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setRunnablePartThreadLimit(Integer runnablePartThreadLimit) {
        this.runnablePartThreadLimit = runnablePartThreadLimit;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public void setConfigPolicy(HeuristicConfigPolicy configPolicy) {
        this.configPolicy = configPolicy;
    }

    @Override
    public String getPhaseTypeString() {
        return "Partitioned Search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(DefaultSolverScope<Solution_> solverScope) {
        PartitionedSearchPhaseScope<Solution_> phaseScope = new PartitionedSearchPhaseScope<Solution_>(solverScope);
        List<Solution_> partList = this.solutionPartitioner.splitWorkingSolution(solverScope.getScoreDirector(), this.runnablePartThreadLimit);
        int partCount = partList.size();
        phaseScope.setPartCount(partCount);
        this.phaseStarted(phaseScope);
        ThreadPoolExecutor threadPoolExecutor = this.createThreadPoolExecutor();
        if (threadPoolExecutor.getMaximumPoolSize() < partCount) {
            throw new IllegalStateException("The threadPoolExecutor's maximumPoolSize (" + threadPoolExecutor.getMaximumPoolSize() + ") is less than the partCount (" + partCount + "), so some partitions will starve.\nNormally this impossible because the threadPoolExecutor should be unbounded: Use runnablePartThreadLimit (" + this.runnablePartThreadLimit + ") instead to avoid CPU hogging and live locks.");
        }
        ChildThreadPlumbingTermination childThreadPlumbingTermination = new ChildThreadPlumbingTermination();
        PartitionQueue partitionQueue = new PartitionQueue(partCount);
        Semaphore runnablePartThreadSemaphore = this.runnablePartThreadLimit == null ? null : new Semaphore(this.runnablePartThreadLimit);
        try {
            Iterator<Object> it = partList.listIterator();
            while (it.hasNext()) {
                int n = it.nextIndex();
                Object part = it.next();
                PartitionSolver partitionSolver = this.buildPartitionSolver(childThreadPlumbingTermination, runnablePartThreadSemaphore, solverScope);
                partitionSolver.addEventListener(event -> {
                    InnerScoreDirector childScoreDirector = partitionSolver.solverScope.getScoreDirector();
                    PartitionChangeMove move = PartitionChangeMove.createMove(childScoreDirector);
                    InnerScoreDirector parentScoreDirector = solverScope.getScoreDirector();
                    move = move.rebase(parentScoreDirector);
                    partitionQueue.addMove(partIndex, move);
                });
                threadPoolExecutor.submit(() -> {
                    try {
                        partitionSolver.solve(part);
                        partitionQueue.addFinish(partIndex);
                    }
                    catch (Throwable throwable) {
                        partitionQueue.addExceptionThrown(partIndex, throwable);
                    }
                });
            }
            for (PartitionChangeMove partitionChangeMove : partitionQueue) {
                PartitionedSearchStepScope<Solution_> stepScope = new PartitionedSearchStepScope<Solution_>(phaseScope);
                this.stepStarted(stepScope);
                stepScope.setStep(partitionChangeMove);
                if (this.logger.isDebugEnabled()) {
                    stepScope.setStepString(partitionChangeMove.toString());
                }
                this.doStep(stepScope);
                this.stepEnded(stepScope);
                phaseScope.setLastCompletedStepScope(stepScope);
            }
        }
        finally {
            childThreadPlumbingTermination.terminateChildren();
            try {
                if (!threadPoolExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.logger.warn("{}Partitioned Search threadPoolExecutor didn't terminate within timeout (1 second).", (Object)this.logIndentation);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread pool shutdown was interrupted.", e);
            }
            finally {
                threadPoolExecutor.shutdownNow();
            }
        }
        this.phaseEnded(phaseScope);
    }

    private ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory);
    }

    public PartitionSolver<Solution_> buildPartitionSolver(ChildThreadPlumbingTermination childThreadPlumbingTermination, Semaphore runnablePartThreadSemaphore, DefaultSolverScope<Solution_> solverScope) {
        OrCompositeTermination partTermination = new OrCompositeTermination(childThreadPlumbingTermination, this.termination.createChildThreadTermination(solverScope, ChildThreadType.PART_THREAD));
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecallerConfig().buildBestSolutionRecaller(this.configPolicy.getEnvironmentMode());
        ArrayList phaseList = new ArrayList(this.phaseConfigList.size());
        int partPhaseIndex = 0;
        for (PhaseConfig phaseConfig : this.phaseConfigList) {
            phaseList.add(phaseConfig.buildPhase(partPhaseIndex, this.configPolicy, bestSolutionRecaller, partTermination));
            ++partPhaseIndex;
        }
        DefaultSolverScope<Solution_> partSolverScope = solverScope.createChildThreadSolverScope(ChildThreadType.PART_THREAD);
        partSolverScope.setRunnableThreadSemaphore(runnablePartThreadSemaphore);
        return new PartitionSolver(partTermination, bestSolutionRecaller, phaseList, partSolverScope);
    }

    protected void doStep(PartitionedSearchStepScope<Solution_> stepScope) {
        PartitionChangeMove nextStep = stepScope.getStep();
        nextStep.doMove(stepScope.getScoreDirector());
        this.calculateWorkingStepScore(stepScope, nextStep);
        this.bestSolutionRecaller.processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void phaseStarted(PartitionedSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(PartitionedSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(PartitionedSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}    PS step ({}), time spent ({}), score ({}), {} best score ({}), picked move ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScore(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(PartitionedSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Partitioned Search phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}), partCount ({}), runnablePartThreadLimit ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex(), phaseScope.getPartCount(), this.runnablePartThreadLimit});
    }
}

