/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class LocalTimeXStreamConverter
implements Converter {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    public void marshal(Object localTimeObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        LocalTime localTime = (LocalTime)localTimeObject;
        writer.setValue(this.formatter.format(localTime));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String localTimeString = reader.getValue();
        try {
            return LocalTime.from(this.formatter.parse(localTimeString));
        }
        catch (DateTimeException e) {
            throw new IllegalStateException("Failed to convert string (" + localTimeString + ") to type (" + LocalTime.class.getName() + ").");
        }
    }

    public boolean canConvert(Class type) {
        return LocalTime.class.isAssignableFrom(type);
    }
}

