/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.kie.util.BeanCreator;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.LiteralRestrictionDescr;
import org.drools.compiler.lang.descr.OperatorDescr;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.compiler.rule.builder.ConstraintBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.util.PatternBuilderUtil;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.constraint.EvaluatorConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.Wireable;
import org.drools.core.time.TimerExpression;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.mvel.MVELConstraint;
import org.drools.mvel.MVELCoreComponentsBuilder;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.MVELSafeHelper;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.builder.MVELAnalysisResult;
import org.drools.mvel.builder.MVELBeanCreator;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.builder.MVELDialectConfiguration;
import org.drools.mvel.builder.MVELExprAnalyzer;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MVELObjectExpression;
import org.drools.mvel.java.JavaForMvelDialectConfiguration;
import org.kie.api.definition.rule.Rule;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.util.CompatibilityStrategy;
import org.mvel2.util.NullType;
import org.mvel2.util.PropertyTools;

public class MVELConstraintBuilder
implements ConstraintBuilder {
    public static final boolean USE_MVEL_EXPRESSION = true;
    protected static final Set<String> MVEL_OPERATORS;

    public DialectConfiguration createJavaDialectConfiguration() {
        return new JavaForMvelDialectConfiguration();
    }

    public DialectConfiguration createMVELDialectConfiguration() {
        return new MVELDialectConfiguration();
    }

    public boolean isMvelOperator(String operator) {
        return MVEL_OPERATORS.contains(operator);
    }

    public boolean useMvelExpression() {
        return true;
    }

    public Constraint buildVariableConstraint(RuleBuildContext context, Pattern pattern, String expression, Declaration[] declarations, String leftValue, OperatorDescr operatorDescr, String rightValue, InternalReadAccessor extractor, Declaration requiredDeclaration, RelationalExprDescr relDescr, Map<String, OperatorDescr> aliases) {
        boolean isUnification;
        if (!this.isMvelOperator(operatorDescr.getOperator())) {
            if (requiredDeclaration == null) {
                return null;
            }
            EvaluatorDefinition.Target right = this.getRightTarget(extractor);
            EvaluatorDefinition.Target left = requiredDeclaration.isPatternDeclaration() && !Date.class.isAssignableFrom(requiredDeclaration.getDeclarationClass()) && !Number.class.isAssignableFrom(requiredDeclaration.getDeclarationClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            Evaluator evaluator = this.getEvaluator(context, (BaseDescr)relDescr, extractor.getValueType(), operatorDescr.getOperator(), relDescr.isNegated(), relDescr.getParametersText(), left, right);
            return new EvaluatorConstraint(new Declaration[]{requiredDeclaration}, evaluator, extractor);
        }
        boolean bl = isUnification = requiredDeclaration != null && requiredDeclaration.getPattern().getObjectType().equals(new ClassObjectType(DroolsQuery.class)) && Operator.EQUAL.getOperatorString().equals(operatorDescr.getOperator());
        if (isUnification && leftValue.equals(rightValue)) {
            expression = MVELConstraintBuilder.resolveUnificationAmbiguity(expression, declarations, leftValue, rightValue);
        }
        expression = MVELConstraintBuilder.normalizeMVELVariableExpression(expression, leftValue, rightValue, relDescr);
        IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.decode((String)operatorDescr.getOperator(), (boolean)operatorDescr.isNegated());
        MVELCompilationUnit compilationUnit = isUnification ? null : this.buildCompilationUnit(context, pattern, expression, aliases);
        EvaluatorWrapper[] operators = PatternBuilder.getOperators((Map)PatternBuilder.buildOperators((RuleBuildContext)context, (Pattern)pattern, (BaseDescr)relDescr, aliases));
        return new MVELConstraint(Collections.singletonList(context.getPkg().getName()), expression, declarations, operators, compilationUnit, constraintType, requiredDeclaration, extractor, isUnification);
    }

    public Constraint buildMvelConstraint(String packageName, String expression, Declaration[] declarations, EvaluatorWrapper[] operators, RuleBuildContext context, Declaration[] previousDeclarations, Declaration[] localDeclarations, PredicateDescr predicateDescr, AnalysisResult analysis, boolean isDynamic) {
        MVELCompilationUnit compilationUnit = this.buildCompilationUnit(context, previousDeclarations, localDeclarations, predicateDescr, analysis);
        return new MVELConstraint(packageName, expression, declarations, operators, compilationUnit, isDynamic);
    }

    public Constraint buildLiteralConstraint(RuleBuildContext context, Pattern pattern, ValueType vtype, FieldValue field, String expression, String leftValue, String operator, boolean negated, String rightValue, InternalReadAccessor extractor, LiteralRestrictionDescr restrictionDescr, Map<String, OperatorDescr> aliases) {
        if (!this.isMvelOperator(operator)) {
            Evaluator evaluator = this.buildLiteralEvaluator(context, extractor, restrictionDescr, vtype);
            if (evaluator != null && evaluator.isTemporal()) {
                try {
                    field = context.getCompilerFactory().getFieldFactory().getFieldValue(field.getValue(), ValueType.DATE_TYPE);
                }
                catch (Exception e) {
                    context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)restrictionDescr, null, e.getMessage()));
                }
            }
            return new EvaluatorConstraint(field, evaluator, extractor);
        }
        String mvelExpr = MVELConstraintBuilder.normalizeMVELLiteralExpression(vtype, field, expression, leftValue, operator, rightValue, negated, restrictionDescr);
        IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.decode((String)operator, (boolean)negated);
        if (constraintType == IndexUtil.ConstraintType.EQUAL && negated) {
            mvelExpr = MVELConstraintBuilder.normalizeDoubleNegation(mvelExpr);
        }
        MVELCompilationUnit compilationUnit = this.buildCompilationUnit(context, pattern, mvelExpr, aliases);
        EvaluatorWrapper[] operators = PatternBuilder.getOperators((Map)PatternBuilder.buildOperators((RuleBuildContext)context, (Pattern)pattern, (BaseDescr)restrictionDescr, aliases));
        return new MVELConstraint(context.getPkg().getName(), mvelExpr, compilationUnit, constraintType, field, extractor, operators);
    }

    private static String normalizeDoubleNegation(String expr) {
        if (expr.charAt(0) == '!') {
            if ((expr = expr.substring(1).trim()).charAt(0) == '(') {
                expr = expr.substring(1, expr.lastIndexOf(41)).trim();
            }
            expr = expr.replace("!=", "==");
        }
        return expr;
    }

    protected static String resolveUnificationAmbiguity(String expr, Declaration[] declrations, String leftValue, String rightValue) {
        rightValue = rightValue + "__";
        for (Declaration declaration : declrations) {
            if (!declaration.getIdentifier().equals(leftValue)) continue;
            declaration.setBindingName(rightValue);
        }
        return leftValue + " == " + rightValue;
    }

    protected static String normalizeMVELLiteralExpression(ValueType vtype, FieldValue field, String expr, String leftValue, String operator, String rightValue, boolean negated, LiteralRestrictionDescr restrictionDescr) {
        if (vtype.getSimpleType() == 8) {
            String normalized = leftValue + " " + operator + PatternBuilderUtil.getNormalizeDate((ValueType)vtype, (FieldValue)field);
            if (!negated) {
                return normalized;
            }
            IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.decode((String)operator);
            return constraintType.getOperator() != null ? leftValue + " " + constraintType.negate().getOperator() + PatternBuilderUtil.getNormalizeDate((ValueType)vtype, (FieldValue)field) : "!(" + normalized + ")";
        }
        if (operator.equals("str")) {
            return PatternBuilderUtil.normalizeStringOperator((String)leftValue, (String)rightValue, (LiteralRestrictionDescr)restrictionDescr);
        }
        return PatternBuilderUtil.normalizeEmptyKeyword((String)expr, (String)operator);
    }

    protected static String normalizeMVELVariableExpression(String expr, String leftValue, String rightValue, RelationalExprDescr relDescr) {
        if (relDescr.getOperator().equals("str")) {
            String method = relDescr.getParametersText();
            if (method.equals("length")) {
                return leftValue + ".length()" + (relDescr.isNegated() ? " != " : " == ") + rightValue;
            }
            return (relDescr.isNegated() ? "!" : "") + leftValue + "." + method + "(" + rightValue + ")";
        }
        return expr;
    }

    public Evaluator buildLiteralEvaluator(RuleBuildContext context, InternalReadAccessor extractor, LiteralRestrictionDescr literalRestrictionDescr, ValueType vtype) {
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        return this.getEvaluator(context, (BaseDescr)literalRestrictionDescr, vtype, literalRestrictionDescr.getEvaluator(), literalRestrictionDescr.isNegated(), literalRestrictionDescr.getParameterText(), left, right);
    }

    public EvaluatorDefinition.Target getRightTarget(InternalReadAccessor extractor) {
        return extractor.isSelfReference() && !Date.class.isAssignableFrom(extractor.getExtractToClass()) && !Number.class.isAssignableFrom(extractor.getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
    }

    public Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString, boolean isNegated, String parameters, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        EvaluatorDefinition def = context.getConfiguration().getEvaluatorRegistry().getEvaluatorDefinition(evaluatorString);
        if (def == null) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the Evaluator for ID '" + evaluatorString + "'"));
            return null;
        }
        Evaluator evaluator = def.getEvaluator(valueType, evaluatorString, isNegated, parameters, left, right);
        if (evaluator == null) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), descr, null, "Evaluator '" + (isNegated ? "not " : "") + evaluatorString + "' does not support type '" + valueType));
        }
        return evaluator;
    }

    public EvaluatorWrapper wrapEvaluator(Evaluator evaluator, Declaration left, Declaration right) {
        return new EvaluatorWrapper(evaluator, left, right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MVELCompilationUnit buildCompilationUnit(RuleBuildContext context, Pattern pattern, String expression, Map<String, OperatorDescr> aliases) {
        Dialect dialect = context.getDialect();
        context.setDialect(context.getDialect("mvel"));
        try {
            PredicateDescr predicateDescr = new PredicateDescr(context.getRuleDescr().getResource(), (Object)expression);
            AnalysisResult analysis = PatternBuilder.buildAnalysis((RuleBuildContext)context, (Pattern)pattern, (PredicateDescr)predicateDescr, aliases);
            if (analysis == null) {
                MVELCompilationUnit mVELCompilationUnit = null;
                return mVELCompilationUnit;
            }
            Declaration[][] usedDeclarations = PatternBuilder.getUsedDeclarations((RuleBuildContext)context, (Pattern)pattern, (AnalysisResult)analysis);
            MVELCompilationUnit mVELCompilationUnit = this.buildCompilationUnit(context, usedDeclarations[0], usedDeclarations[1], predicateDescr, analysis);
            return mVELCompilationUnit;
        }
        finally {
            context.setDialect(dialect);
        }
    }

    private MVELCompilationUnit buildCompilationUnit(RuleBuildContext context, Declaration[] previousDeclarations, Declaration[] localDeclarations, PredicateDescr predicateDescr, AnalysisResult analysis) {
        Class<?> returnClass;
        if (context.isTypesafe() && analysis instanceof MVELAnalysisResult && (returnClass = ((MVELAnalysisResult)analysis).getReturnType()) != Boolean.class && returnClass != Boolean.TYPE) {
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)predicateDescr, null, "Predicate '" + predicateDescr.getContent() + "' must be a Boolean expression\n" + predicateDescr.positionAsString()));
        }
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        MVELCompilationUnit unit = null;
        try {
            Map declIds = context.getDeclarationResolver().getDeclarationClasses(context.getRule());
            Pattern p = (Pattern)context.getDeclarationResolver().peekBuildStack();
            if (p.getObjectType() instanceof ClassObjectType) {
                declIds.put("this", ((ClassObjectType)p.getObjectType()).getClassType());
            }
            unit = MVELDialect.getMVELCompilationUnit((String)predicateDescr.getContent(), analysis, previousDeclarations, localDeclarations, null, (PackageBuildContext)context, "drools", KnowledgeHelper.class, context.isInXpath(), MVELCompilationUnit.Scope.CONSTRAINT);
        }
        catch (Exception e) {
            AsmUtil.copyErrorLocation(e, (BaseDescr)predicateDescr);
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)predicateDescr, (Object)e, "Unable to build expression for 'inline-eval' : " + e.getMessage() + "'" + predicateDescr.getContent() + "'\n" + e.getMessage()));
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerExpression buildTimerExpression(String expression, RuleBuildContext context) {
        boolean typesafe = context.isTypesafe();
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            MVELAnalysisResult analysis = (MVELAnalysisResult)dialect.analyzeExpression((PackageBuildContext)context, (BaseDescr)context.getRuleDescr(), expression, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), (PackageBuildContext)context));
            context.setTypesafe(analysis.isTypesafe());
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            int i = usedIdentifiers.getDeclrClasses().keySet().size();
            Declaration[] previousDeclarations = new Declaration[i];
            i = 0;
            for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
                previousDeclarations[i++] = (Declaration)decls.get(id);
            }
            Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = MVELDialect.getMVELCompilationUnit(expression, analysis, previousDeclarations, null, null, (PackageBuildContext)context, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.EXPRESSION);
            MVELObjectExpression expr = new MVELObjectExpression(unit, dialect.getId());
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)context.getRule(), expr);
            expr.compile(data);
            MVELObjectExpression mVELObjectExpression = expr;
            return mVELObjectExpression;
        }
        catch (Exception e) {
            AsmUtil.copyErrorLocation(e, (BaseDescr)context.getRuleDescr());
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)context.getRuleDescr(), null, "Unable to build expression : " + e.getMessage() + "'" + expression + "'"));
            TimerExpression timerExpression = null;
            return timerExpression;
        }
        finally {
            context.setTypesafe(typesafe);
        }
    }

    public TimerExpression buildTimerExpression(String expression, ClassLoader classLoader, Map<String, Declaration> decls) {
        if (expression == null) {
            return null;
        }
        ParserConfiguration conf = new ParserConfiguration();
        conf.setClassLoader(classLoader);
        MVELAnalysisResult analysis = MVELConstraintBuilder.analyzeExpression(expression, conf, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses(decls), null));
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        int i = usedIdentifiers.getDeclrClasses().keySet().size();
        Declaration[] previousDeclarations = new Declaration[i];
        i = 0;
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            previousDeclarations[i++] = decls.get(id);
        }
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        MVELCompilationUnit unit = MVELDialect.getMVELCompilationUnit(expression, analysis, previousDeclarations, null, null, null, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.EXPRESSION);
        MVELObjectExpression expr = new MVELObjectExpression(unit, "mvel");
        expr.compile(conf);
        return expr;
    }

    public AnalysisResult analyzeExpression(Class<?> thisClass, String expr) {
        ParserConfiguration conf = new ParserConfiguration();
        conf.setClassLoader(thisClass.getClassLoader());
        return MVELConstraintBuilder.analyzeExpression(expr, conf, new BoundIdentifiers(thisClass));
    }

    private static MVELAnalysisResult analyzeExpression(String expr, ParserConfiguration conf, BoundIdentifiers availableIdentifiers) {
        Class returnType;
        if (expr.trim().length() <= 0) {
            MVELAnalysisResult result = MVELExprAnalyzer.analyze(Collections.EMPTY_SET, availableIdentifiers);
            result.setMvelVariables(new HashMap());
            result.setTypesafe(true);
            return result;
        }
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        ParserContext parserContext1 = new ParserContext(conf);
        if (availableIdentifiers.getThisClass() != null) {
            parserContext1.addInput("this", availableIdentifiers.getThisClass());
        }
        if (availableIdentifiers.getOperators() != null) {
            for (Map.Entry opEntry : availableIdentifiers.getOperators().entrySet()) {
                parserContext1.addInput((String)opEntry.getKey(), ((EvaluatorWrapper)opEntry.getValue()).getClass());
            }
        }
        parserContext1.setStrictTypeEnforcement(false);
        parserContext1.setStrongTyping(false);
        try {
            returnType = MVEL.analyze((String)expr, (ParserContext)parserContext1);
        }
        catch (Exception e) {
            return null;
        }
        HashSet<Object> requiredInputs = new HashSet(parserContext1.getInputs().keySet());
        HashMap variables = parserContext1.getVariables();
        if (availableIdentifiers.getThisClass() != null) {
            requiredInputs.removeIf(s -> PropertyTools.getFieldOrAccessor((Class)availableIdentifiers.getThisClass(), (String)s) != null);
        }
        ParserContext parserContext2 = new ParserContext(conf);
        parserContext2.setStrictTypeEnforcement(true);
        parserContext2.setStrongTyping(true);
        for (String string : requiredInputs) {
            if ("this".equals(string)) continue;
            if ("_workingMemory_".equals(string)) {
                parserContext2.addInput(string, InternalWorkingMemory.class);
                continue;
            }
            Class<Rule> cls = availableIdentifiers.resolveType(string);
            if (cls == null && string.equals("rule")) {
                cls = Rule.class;
            }
            if (cls == null) continue;
            parserContext2.addInput(string, cls);
        }
        if (availableIdentifiers.getThisClass() != null) {
            parserContext2.addInput("this", availableIdentifiers.getThisClass());
        }
        try {
            returnType = MVEL.analyze((String)expr, (ParserContext)parserContext2);
        }
        catch (Exception e) {
            return null;
        }
        requiredInputs = new HashSet();
        requiredInputs.addAll(parserContext2.getInputs().keySet());
        requiredInputs.addAll(variables.keySet());
        variables = parserContext2.getVariables();
        MVELAnalysisResult result = MVELExprAnalyzer.analyze(requiredInputs, availableIdentifiers);
        result.setReturnType(returnType);
        result.setMvelVariables(variables);
        result.setTypesafe(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalReadAccessor buildMvelFieldReadAccessor(RuleBuildContext context, BaseDescr descr, Pattern pattern, ObjectType objectType, String fieldName, boolean reportError) {
        InternalReadAccessor reader;
        Dialect dialect = context.getDialect();
        try {
            MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
            context.setDialect((Dialect)mvelDialect);
            AnalysisResult analysis = context.getDialect().analyzeExpression((PackageBuildContext)context, descr, (Object)fieldName, new BoundIdentifiers(pattern, (PackageBuildContext)context, Collections.EMPTY_MAP, objectType.getClassType()));
            if (analysis == null) {
                if (reportError) {
                    PatternBuilder.registerDescrBuildError((RuleBuildContext)context, (BaseDescr)descr, (String)("Unable to analyze expression '" + fieldName + "'"));
                }
                InternalReadAccessor internalReadAccessor = null;
                return internalReadAccessor;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            if (!usedIdentifiers.getDeclrClasses().isEmpty()) {
                if (reportError && descr instanceof BindingDescr) {
                    PatternBuilder.registerDescrBuildError((RuleBuildContext)context, (BaseDescr)descr, (String)("Variables can not be used inside bindings. Variable " + usedIdentifiers.getDeclrClasses().keySet() + " is being used in binding '" + fieldName + "'"));
                }
                InternalReadAccessor internalReadAccessor = null;
                return internalReadAccessor;
            }
            reader = context.getPkg().getClassFieldAccessorStore().getMVELReader(context.getPkg().getName(), objectType.getClassName(), fieldName, context.isTypesafe(), ((MVELAnalysisResult)analysis).getReturnType());
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            ((MVELCompileable)reader).compile(data, context.getRule());
            data.addCompileable((MVELCompileable)reader);
        }
        catch (Exception e) {
            String varName;
            int dotPos = fieldName.indexOf(46);
            String string = varName = dotPos > 0 ? fieldName.substring(0, dotPos).trim() : fieldName;
            if (context.getKnowledgeBuilder().getGlobals().containsKey(varName)) {
                InternalReadAccessor internalReadAccessor = null;
                return internalReadAccessor;
            }
            if (reportError) {
                AsmUtil.copyErrorLocation(e, descr);
                PatternBuilder.registerDescrBuildError((RuleBuildContext)context, (BaseDescr)descr, (Object)e, (String)("Unable to create reader for '" + fieldName + "':" + e.getMessage()));
            }
            reader = null;
        }
        finally {
            context.setDialect(dialect);
        }
        return reader;
    }

    public void setExprInputs(RuleBuildContext context, PatternBuilder.ExprBindings descrBranch, Class<?> thisClass, String expr) {
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
        ParserConfiguration conf = data.getParserConfiguration();
        conf.setClassLoader(context.getKnowledgeBuilder().getRootClassLoader());
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(false);
        pctx.setStrongTyping(false);
        pctx.addInput("this", thisClass);
        pctx.addInput("empty", Boolean.TYPE);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        try {
            MVEL.analysisCompile((String)expr, (ParserContext)pctx);
        }
        catch (Exception e) {
            return;
        }
        if (!pctx.getInputs().isEmpty()) {
            for (String v : pctx.getInputs().keySet()) {
                if ("this".equals(v) || PropertyTools.getFieldOrAccessor(thisClass, (String)v) != null && expr.matches("(^|.*\\W)empty($|\\W.*)")) {
                    descrBranch.getFieldAccessors().add(v);
                    continue;
                }
                if ("empty".equals(v)) continue;
                if (!context.getPkg().getGlobals().containsKey(v)) {
                    descrBranch.getRuleBindings().add(v);
                    continue;
                }
                descrBranch.getGlobalBindings().add(v);
            }
        }
    }

    public FieldValue getMvelFieldValue(RuleBuildContext context, ValueType vtype, String value) {
        try {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            ParserConfiguration pconf = data.getParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            Object o = MVELSafeHelper.getEvaluator().executeExpression((Object)MVEL.compileExpression((String)value, (ParserContext)pctx));
            if (o != null && vtype == null) {
                vtype = ValueType.determineValueType(o.getClass());
            }
            return context.getCompilerFactory().getFieldFactory().getFieldValue(o, vtype);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public QueryArgument buildExpressionQueryArgument(RuleBuildContext context, List<Declaration> declarations, String expression) {
        return new Expression(declarations, expression, this.getParserContext(context));
    }

    public BeanCreator createMVELBeanCreator(Map<String, Object> parameters) {
        return new MVELBeanCreator(parameters);
    }

    private ParserContext getParserContext(RuleBuildContext context) {
        return MVELCoreComponentsBuilder.getParserContext(context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel"), context.getKnowledgeBuilder().getRootClassLoader());
    }

    static {
        CompatibilityStrategy.setCompatibilityEvaluator((CompatibilityStrategy.CompatibilityEvaluator)StringCoercionCompatibilityEvaluator.INSTANCE);
        DataConversion.addConversionHandler(Boolean.class, (ConversionHandler)BooleanConversionHandler.INSTANCE);
        DataConversion.addConversionHandler(Boolean.TYPE, (ConversionHandler)BooleanConversionHandler.INSTANCE);
        MVEL_OPERATORS = new HashSet<String>(){
            {
                this.add("==");
                this.add("!=");
                this.add(">");
                this.add(">=");
                this.add("<");
                this.add("<=");
                this.add("~=");
                this.add("str");
                this.add("contains");
                this.add("matches");
                this.add("excludes");
                this.add("memberOf");
                this.add("instanceof");
            }
        };
    }

    public static class Expression
    implements QueryArgument {
        private List<Declaration> declarations;
        private String expression;
        private ParserContext parserContext;
        private transient Class<?> argumentClass;
        private transient Serializable mvelExpr;

        public Expression() {
        }

        public Expression(List<Declaration> declarations, String expression, ParserContext parserContext) {
            this.declarations = declarations;
            this.expression = expression;
            this.parserContext = parserContext;
            this.init();
        }

        private void init() {
            HashMap<String, Class> inputs = new HashMap<String, Class>();
            for (Declaration d : this.declarations) {
                inputs.put(d.getBindingName(), d.getDeclarationClass());
            }
            this.parserContext.setInputs(inputs);
            this.argumentClass = MVEL.analyze((String)this.expression, (ParserContext)this.parserContext);
            this.mvelExpr = MVEL.compileExpression((String)this.expression, (ParserContext)this.parserContext);
        }

        public Object getValue(InternalWorkingMemory wm, LeftTuple leftTuple) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            for (Declaration d : this.declarations) {
                vars.put(d.getBindingName(), QueryArgument.evaluateDeclaration((InternalWorkingMemory)wm, (LeftTuple)leftTuple, (Declaration)d));
            }
            return MVELSafeHelper.getEvaluator().executeExpression((Object)this.mvelExpr, vars);
        }

        public QueryArgument normalize(ClassLoader classLoader) {
            this.parserContext.getParserConfiguration().setClassLoader(classLoader);
            return new Expression(this.declarations, this.expression, this.parserContext);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.declarations);
            out.writeObject(this.expression);
            out.writeObject(this.parserContext);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.declarations = (List)in.readObject();
            this.expression = (String)in.readObject();
            this.parserContext = (ParserContext)in.readObject();
            ParserConfiguration newConf = new ParserConfiguration();
            newConf.setImports(this.parserContext.getParserConfiguration().getImports());
            newConf.setPackageImports(this.parserContext.getParserConfiguration().getPackageImports());
            this.parserContext = new ParserContext(newConf);
            this.parserContext.setInputs(this.parserContext.getInputs());
            this.parserContext.setVariables(this.parserContext.getVariables());
            this.init();
        }
    }

    public static class StringCoercionCompatibilityEvaluator
    extends CompatibilityStrategy.DefaultCompatibilityEvaluator {
        private static final CompatibilityStrategy.CompatibilityEvaluator INSTANCE = new StringCoercionCompatibilityEvaluator();

        private StringCoercionCompatibilityEvaluator() {
        }

        public boolean areEqualityCompatible(Class<?> c1, Class<?> c2) {
            Class boxed2;
            if (c1 == NullType.class || c2 == NullType.class) {
                return true;
            }
            if (c1 == String.class || c2 == String.class) {
                return true;
            }
            Class boxed1 = ClassUtils.convertFromPrimitiveType(c1);
            if (boxed1.isAssignableFrom(boxed2 = ClassUtils.convertFromPrimitiveType(c2)) || boxed2.isAssignableFrom(boxed1)) {
                return true;
            }
            if (Number.class.isAssignableFrom(boxed1) && Number.class.isAssignableFrom(boxed2)) {
                return true;
            }
            return !Modifier.isFinal(c1.getModifiers()) && !Modifier.isFinal(c2.getModifiers());
        }

        public boolean areComparisonCompatible(Class<?> c1, Class<?> c2) {
            return super.areEqualityCompatible(c1, c2);
        }
    }

    public static class BooleanConversionHandler
    implements ConversionHandler {
        private static final BooleanConversionHandler INSTANCE = new BooleanConversionHandler();

        private BooleanConversionHandler() {
        }

        public Object convertFrom(Object in) {
            if (in.getClass() == Boolean.class || in.getClass() == Boolean.TYPE) {
                return in;
            }
            return in instanceof String && ((String)in).equalsIgnoreCase("true");
        }

        public boolean canConvertFrom(Class cls) {
            return cls == Boolean.class || cls == Boolean.TYPE || cls == String.class;
        }
    }
}

