/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.travelingtournament.domain.Day;
import org.optaplanner.examples.travelingtournament.domain.Match;

public final class TravelingTournamentConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.fourConsecutiveHomeMatches(constraintFactory), this.fourConsecutiveAwayMatches(constraintFactory), this.repeatMatchOnTheNextDay(constraintFactory), this.startToAwayHop(constraintFactory), this.homeToAwayHop(constraintFactory), this.awayToAwayHop(constraintFactory), this.awayToHomeHop(constraintFactory), this.awayToEndHop(constraintFactory)};
    }

    private Constraint fourConsecutiveHomeMatches(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).ifExists(Match.class, Joiners.equal(Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 2, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 3, TravelingTournamentConstraintProvider::getDayIndex)).penalize("4 consecutive home matches", (Score)HardSoftScore.ONE_HARD);
    }

    private Constraint fourConsecutiveAwayMatches(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).ifExists(Match.class, Joiners.equal(Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 2, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 3, TravelingTournamentConstraintProvider::getDayIndex)).penalize("4 consecutive away matches", (Score)HardSoftScore.ONE_HARD);
    }

    private Constraint repeatMatchOnTheNextDay(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).ifExists(Match.class, Joiners.equal(Match::getHomeTeam, Match::getAwayTeam), Joiners.equal(Match::getAwayTeam, Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize("Repeat match on the next day", (Score)HardSoftScore.ONE_HARD);
    }

    private Constraint startToAwayHop(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).ifNotExists(Day.class, Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) - 1, Day::getIndex)).penalize("Start to away hop", (Score)HardSoftScore.ONE_SOFT, match -> match.getAwayTeam().getDistance(match.getHomeTeam()));
    }

    private Constraint homeToAwayHop(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).join(Match.class, Joiners.equal(Match::getHomeTeam, Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize("Home to away hop", (Score)HardSoftScore.ONE_SOFT, (match, otherMatch) -> match.getHomeTeam().getDistance(otherMatch.getHomeTeam()));
    }

    private Constraint awayToAwayHop(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).join(Match.class, Joiners.equal(Match::getAwayTeam, Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize("Away to away hop", (Score)HardSoftScore.ONE_SOFT, (match, otherMatch) -> match.getHomeTeam().getDistance(otherMatch.getHomeTeam()));
    }

    private Constraint awayToHomeHop(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).join(Match.class, Joiners.equal(Match::getAwayTeam, Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize("Away to home hop", (Score)HardSoftScore.ONE_SOFT, (match, otherMatch) -> match.getHomeTeam().getDistance(match.getAwayTeam()));
    }

    private Constraint awayToEndHop(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Match.class).ifNotExists(Day.class, Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, Day::getIndex)).penalize("Away to end hop", (Score)HardSoftScore.ONE_SOFT, match -> match.getHomeTeam().getDistance(match.getAwayTeam()));
    }

    private static int getDayIndex(Match match) {
        return match.getDay().getIndex();
    }
}

