/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableDemand;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.IterableSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.TailChainSwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class TailChainSwapMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector entitySelector;
    protected final ValueSelector valueSelector;
    protected final boolean randomSelection;
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected AnchorVariableSupply anchorVariableSupply;

    public TailChainSwapMoveSelector(EntitySelector entitySelector, ValueSelector valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        if (!variableDescriptor.isChained()) {
            throw new IllegalStateException("The selector (" + this + ")'s valueSelector's  variableDescriptor (" + variableDescriptor + ") must be chained (" + variableDescriptor.isChained() + ").");
        }
        if (!variableDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(entitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal or a superclass to the entitySelector's entityClass (" + entitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(variableDescriptor));
        this.anchorVariableSupply = supplyManager.demand(new AnchorVariableDemand(variableDescriptor));
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.anchorVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        Iterator<Object> it = this.entitySelector.endingIterator();
        while (it.hasNext()) {
            Object entity = it.next();
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        final GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        if (!this.randomSelection) {
            return new AbstractOriginalChangeIterator<Move>(this.entitySelector, this.valueSelector){

                @Override
                protected Move newChangeSelection(Object entity, Object toValue) {
                    return new TailChainSwapMove(variableDescriptor, TailChainSwapMoveSelector.this.inverseVariableSupply, TailChainSwapMoveSelector.this.anchorVariableSupply, entity, toValue);
                }
            };
        }
        return new AbstractRandomChangeIterator<Move>(this.entitySelector, this.valueSelector){

            @Override
            protected Move newChangeSelection(Object entity, Object toValue) {
                return new TailChainSwapMove(variableDescriptor, TailChainSwapMoveSelector.this.inverseVariableSupply, TailChainSwapMoveSelector.this.anchorVariableSupply, entity, toValue);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }
}

