/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.optional.score;

import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.examples.rocktour.domain.RockShow;

public class RockTourConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredShow(constraintFactory), this.unassignedShow(constraintFactory), this.revenueOpportunity(constraintFactory), this.drivingTimeToShowPerSecond(constraintFactory), this.drivingTimeToBusArrivalPerSecond(constraintFactory), this.delayShowCostPerDay(constraintFactory), this.shortenDrivingTimePerMillisecondSquared(constraintFactory)};
    }

    private UniConstraintStream<RockShow> getShowWithoutDate(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUnfiltered(RockShow.class).filter(rockShow -> rockShow.getDate() == null);
    }

    private Constraint requiredShow(ConstraintFactory constraintFactory) {
        return this.getShowWithoutDate(constraintFactory).filter(RockShow::isRequired).penalizeConfigurable("Required show");
    }

    private Constraint unassignedShow(ConstraintFactory constraintFactory) {
        return this.getShowWithoutDate(constraintFactory).filter(rockShow -> rockShow.getBus() != null).penalizeConfigurable("Unassigned show");
    }

    private Constraint revenueOpportunity(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RockShow.class).filter(rockShow -> rockShow.getDate() != null).rewardConfigurableLong("Revenue opportunity", RockShow::getRevenueOpportunity);
    }

    private Constraint delayShowCostPerDay(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RockShow.class).filter(rockShow -> rockShow.getDate() != null).penalizeConfigurableLong("Delay show cost per day", RockShow::getDaysAfterBusDeparture);
    }

    private Constraint drivingTimeToShowPerSecond(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RockShow.class).filter(rockShow -> rockShow.getPreviousStandstill() != null).penalizeConfigurableLong("Driving time to show per second", RockShow::getDrivingTimeFromPreviousStandstill);
    }

    private Constraint shortenDrivingTimePerMillisecondSquared(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RockShow.class).filter(rockShow -> rockShow.getPreviousStandstill() != null).penalizeConfigurableLong("Shorten driving time per millisecond squared", rockShow -> rockShow.getDrivingTimeFromPreviousStandstill() * rockShow.getDrivingTimeFromPreviousStandstill());
    }

    private Constraint drivingTimeToBusArrivalPerSecond(ConstraintFactory constraintFactory) {
        return constraintFactory.from(RockShow.class).filter(rockShow -> rockShow.getBus() != null).filter(rockShow -> rockShow.getNextShow() == null).penalizeConfigurableLong("Driving time to bus arrival per second", RockShow::getDrivingTimeToBusArrivalLocation);
    }
}

