/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.TupleList;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    protected boolean unwrapRightObject;
    protected Accumulate accumulate;
    protected AlphaNodeFieldConstraint[] resultConstraints;
    protected BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder, context);
        this.resultBinder = resultBinder;
        this.resultBinder.init(context, this.getType());
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.unwrapRightObject = unwrapRightObject;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.addAccFunctionDeclarationsToLeftMask(context.getKnowledgeBase(), leftInput, accumulate);
        this.hashcode = this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ Arrays.hashCode(this.resultConstraints);
    }

    private void addAccFunctionDeclarationsToLeftMask(InternalKnowledgeBase kbase, LeftTupleSource leftInput, Accumulate accumulate) {
        TypeDeclaration typeDeclaration;
        BitMask leftMask = this.getLeftInferredMask();
        ObjectType leftObjectType = leftInput.getObjectType();
        if (leftObjectType instanceof ClassObjectType && (typeDeclaration = kbase.getExactTypeDeclaration(leftObjectType.getClassType())) != null && typeDeclaration.isPropertyReactive()) {
            List<String> accessibleProperties = typeDeclaration.getAccessibleProperties();
            for (Declaration decl : accumulate.getRequiredDeclarations()) {
                if (!leftObjectType.equals(decl.getPattern().getObjectType())) continue;
                leftMask = leftMask.setAll(decl.getPattern().getPositiveWatchMask(accessibleProperties));
            }
        }
        this.setLeftInferredMask(leftMask);
    }

    @Override
    protected ObjectType getObjectTypeForPropertyReactivity(LeftInputAdapterNode leftInput, Pattern pattern) {
        return pattern != null && this.isRightInputIsRiaNode() ? pattern.getObjectType() : leftInput.getParentObjectSource().getObjectTypeNode().getObjectType();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.unwrapRightObject = in.readBoolean();
        this.accumulate = (Accumulate)in.readObject();
        this.resultConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.resultBinder = (BetaConstraints)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.unwrapRightObject);
        out.writeObject(this.accumulate);
        out.writeObject(this.resultConstraints);
        out.writeObject(this.resultBinder);
    }

    @Override
    public short getType() {
        return 211;
    }

    public Accumulate getAccumulate() {
        return this.accumulate;
    }

    public AlphaNodeFieldConstraint[] getResultConstraints() {
        return this.resultConstraints;
    }

    public BetaConstraints getResultBinder() {
        return this.resultBinder;
    }

    public boolean isUnwrapRightObject() {
        return this.unwrapRightObject;
    }

    public InternalFactHandle createResultFactHandle(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, Object result) {
        InternalFactHandle handle = null;
        if (context.getReaderContext() != null) {
            handle = context.getReaderContext().createAccumulateHandle(context.getEntryPoint(), workingMemory, leftTuple, result, this.getId());
        }
        if (handle == null) {
            handle = workingMemory.getFactHandleFactory().newFactHandle(result, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory, null);
        }
        return handle;
    }

    @Override
    public void attach(BuildContext context) {
        super.attach(context);
    }

    @Override
    protected int calculateHashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AccumulateNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.rightInput.getId() == other.rightInput.getId() && this.constraints.equals(other.constraints) && this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        BetaMemory betaMemory = this.constraints.createBetaMemory(config, (short)211);
        AccumulateMemory memory = this.accumulate.isMultiFunction() ? new MultiAccumulateMemory(betaMemory, this.accumulate.getAccumulators()) : new SingleAccumulateMemory(betaMemory, this.accumulate.getAccumulators()[0]);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        return memory;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        BetaMemory bm = memory.getBetaMemory();
        rightTuple.setPropagationContext(pctx);
        this.doDeleteRightTuple(rightTuple, workingMemory, bm);
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            this.getRightInput().removeObjectSink(this);
            return true;
        }
        return false;
    }

    public static class GroupByContext
    implements BaseAccumulation {
        private PropagationContext propagationContext;
        private Map<Object, TupleList<AccumulateContextEntry>> groupsMap = new HashMap<Object, TupleList<AccumulateContextEntry>>();
        private TupleList<AccumulateContextEntry> lastTupleList;
        private TupleList<AccumulateContextEntry> tupleList;
        private TupleList<AccumulateContextEntry> toPropagateList;

        @Override
        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        @Override
        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }

        public Map<Object, TupleList<AccumulateContextEntry>> getGroups() {
            return this.groupsMap;
        }

        public TupleList<AccumulateContextEntry> getGroup(Object workingMemoryContext, Accumulate accumulate, Tuple leftTuple, InternalFactHandle handle, Object key, WorkingMemory wm) {
            return this.groupsMap.computeIfAbsent(key, k -> {
                AccumulateContextEntry entry = new AccumulateContextEntry(key);
                TupleList<AccumulateContextEntry> tupleList = new TupleList<AccumulateContextEntry>(entry);
                entry.setTupleList(tupleList);
                this.addTupleList(tupleList);
                Object functionContext = accumulate.createFunctionContext();
                entry.setFunctionContext(functionContext);
                accumulate.init(workingMemoryContext, entry, leftTuple, wm);
                return tupleList;
            });
        }

        public void removeGroup(Object key) {
            this.groupsMap.remove(key);
        }

        public void addTupleList(TupleList<AccumulateContextEntry> list) {
            if (this.tupleList != null) {
                this.tupleList.setPrevious(list);
                list.setNext(this.tupleList);
            }
            this.tupleList = list;
        }

        public void moveToPropagateTupleList(TupleList<AccumulateContextEntry> list) {
            if (list.getContext().isToPropagate()) {
                return;
            }
            TupleList next = list.getNext();
            if (this.tupleList == list) {
                this.tupleList = next;
                if (next != null) {
                    next.setPrevious(null);
                }
            } else {
                TupleList prev = list.getPrevious();
                prev.setNext(next);
                if (next != null) {
                    next.setPrevious(prev);
                }
            }
            if (this.toPropagateList != null) {
                this.toPropagateList.setPrevious(list);
            }
            list.setNext(this.toPropagateList);
            list.setPrevious(null);
            this.toPropagateList = list;
            list.getContext().setToPropagate(true);
        }

        public void resetToPropagateTupleList(TupleList first, TupleList last) {
            if (first == null) {
                return;
            }
            if (this.tupleList == null) {
                this.tupleList = this.toPropagateList;
            } else {
                last.setNext(this.tupleList);
                this.tupleList.setPrevious(last);
                this.tupleList = first;
            }
            this.toPropagateList = null;
        }

        public TupleList<AccumulateContextEntry> getTupleList() {
            return this.tupleList;
        }

        public TupleList<AccumulateContextEntry> getToPropagateList() {
            return this.toPropagateList;
        }

        public TupleList<AccumulateContextEntry> getLastTupleList() {
            return this.lastTupleList;
        }

        public void setLastTupleList(TupleList<AccumulateContextEntry> lastTupleList) {
            this.lastTupleList = lastTupleList;
        }

        public void clear() {
            for (TupleList<AccumulateContextEntry> list : this.groupsMap.values()) {
                Tuple tuple = list.getFirst();
                while (list.getFirst() != null) {
                    list.remove(tuple);
                    tuple.setContextObject(null);
                    tuple = list.getFirst();
                }
            }
            this.getGroups().clear();
            this.tupleList = null;
            this.toPropagateList = null;
            this.lastTupleList = null;
        }
    }

    public static class AccumulateContext
    extends AccumulateContextEntry
    implements BaseAccumulation {
        private PropagationContext propagationContext;

        public AccumulateContext() {
            super(null);
        }

        @Override
        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        @Override
        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }
    }

    public static class AccumulateContextEntry {
        private Object key;
        private InternalFactHandle resultFactHandle;
        private LeftTuple resultLeftTuple;
        private boolean propagated;
        private Object functionContext;
        private boolean toPropagate;
        private Object value;
        private TupleList<AccumulateContextEntry> tupleList;

        public AccumulateContextEntry(Object key) {
            this.key = key;
        }

        public InternalFactHandle getResultFactHandle() {
            return this.resultFactHandle;
        }

        public void setResultFactHandle(InternalFactHandle resultFactHandle) {
            this.resultFactHandle = resultFactHandle;
        }

        public LeftTuple getResultLeftTuple() {
            return this.resultLeftTuple;
        }

        public void setResultLeftTuple(LeftTuple resultLeftTuple) {
            this.resultLeftTuple = resultLeftTuple;
        }

        public boolean isPropagated() {
            return this.propagated;
        }

        public void setPropagated(boolean propagated) {
            this.propagated = propagated;
        }

        public boolean isToPropagate() {
            return this.toPropagate;
        }

        public void setToPropagate(boolean toPropagate) {
            this.toPropagate = toPropagate;
        }

        public Object getFunctionContext() {
            return this.functionContext;
        }

        public void setFunctionContext(Object context) {
            this.functionContext = context;
        }

        public Object getKey() {
            return this.key;
        }

        public TupleList<AccumulateContextEntry> getTupleList() {
            return this.tupleList;
        }

        public void setTupleList(TupleList<AccumulateContextEntry> tupleList) {
            this.tupleList = tupleList;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static interface BaseAccumulation {
        public PropagationContext getPropagationContext();

        public void setPropagationContext(PropagationContext var1);
    }

    public static class MultiAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator[] accumulators;

        public MultiAccumulateMemory(BetaMemory betaMemory, Accumulator[] accumulators) {
            super(betaMemory);
            this.accumulators = accumulators;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = new Object[this.accumulators.length];
            for (int i = 0; i < this.accumulators.length; ++i) {
                ((Object[])this.workingMemoryContext)[i] = this.accumulators[i].createWorkingMemoryContext();
            }
        }
    }

    public static class SingleAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator accumulator;

        public SingleAccumulateMemory(BetaMemory betaMemory, Accumulator accumulator) {
            super(betaMemory);
            this.accumulator = accumulator;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = this.accumulator.createWorkingMemoryContext();
        }
    }

    public static abstract class AccumulateMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        public Object workingMemoryContext;
        private final BetaMemory betaMemory;
        public ContextEntry[] resultsContext;

        protected AccumulateMemory(BetaMemory betaMemory) {
            this.betaMemory = betaMemory;
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public short getNodeType() {
            return 211;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        @Override
        public abstract void reset();

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }
}

