/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Invoker;
import org.drools.core.spi.Tuple;
import org.kie.internal.security.KiePolicyHelper;

public interface Accumulator
extends Invoker {
    public Object createWorkingMemoryContext();

    public Serializable createContext();

    public Object init(Object var1, Object var2, Tuple var3, Declaration[] var4, WorkingMemory var5);

    public Object accumulate(Object var1, Object var2, Tuple var3, InternalFactHandle var4, Declaration[] var5, Declaration[] var6, WorkingMemory var7);

    public boolean supportsReverse();

    public boolean tryReverse(Object var1, Object var2, Tuple var3, InternalFactHandle var4, Object var5, Declaration[] var6, Declaration[] var7, WorkingMemory var8);

    public Object getResult(Object var1, Object var2, Tuple var3, Declaration[] var4, WorkingMemory var5);

    public static boolean isCompiledInvoker(Accumulator accumulator) {
        return accumulator instanceof CompiledInvoker || accumulator instanceof SafeAccumulator && ((SafeAccumulator)accumulator).wrapsCompiledInvoker();
    }

    public static class SafeAccumulator
    implements Accumulator,
    Serializable {
        private static final long serialVersionUID = -2845820209337318924L;
        private Accumulator delegate;

        public SafeAccumulator(Accumulator delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createWorkingMemoryContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return delegate.createWorkingMemoryContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Serializable createContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Serializable>(){

                @Override
                public Serializable run() {
                    return delegate.createContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Object init(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final Declaration[] declarations, final WorkingMemory workingMemory) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return delegate.init(workingMemoryContext, context, leftTuple, declarations, workingMemory);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object accumulate(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final InternalFactHandle handle, final Declaration[] declarations, final Declaration[] innerDeclarations, final WorkingMemory workingMemory) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return delegate.accumulate(workingMemoryContext, context, leftTuple, handle, declarations, innerDeclarations, workingMemory);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
            throw new IllegalStateException("Should not reach here, as it should return from the prior 'run'");
        }

        @Override
        public boolean supportsReverse() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return delegate.supportsReverse();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean tryReverse(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final InternalFactHandle handle, final Object value, final Declaration[] declarations, final Declaration[] innerDeclarations, final WorkingMemory workingMemory) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        return delegate.tryReverse(workingMemoryContext, context, leftTuple, handle, value, declarations, innerDeclarations, workingMemory);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object getResult(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final Declaration[] declarations, final WorkingMemory workingMemory) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return delegate.getResult(workingMemoryContext, context, leftTuple, declarations, workingMemory);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

