/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain.solver;

import java.util.Comparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.LeadingExam;
import org.optaplanner.examples.examination.domain.PeriodPenalty;

public class ExamDifficultyWeightFactory
implements SelectionSorterWeightFactory<Examination, Exam> {
    public ExamDifficultyWeight createSorterWeight(Examination examination, Exam exam) {
        int studentSizeTotal = exam.getTopicStudentSize();
        int maximumDuration = exam.getTopicDuration();
        block10: for (PeriodPenalty periodPenalty : examination.getPeriodPenaltyList()) {
            if (periodPenalty.getLeftTopic().equals(exam.getTopic())) {
                switch (periodPenalty.getPeriodPenaltyType()) {
                    case EXAM_COINCIDENCE: {
                        studentSizeTotal += periodPenalty.getRightTopic().getStudentSize();
                        maximumDuration = Math.max(maximumDuration, periodPenalty.getRightTopic().getDuration());
                        continue block10;
                    }
                    case EXCLUSION: {
                        continue block10;
                    }
                    case AFTER: {
                        continue block10;
                    }
                }
                throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenalty.getPeriodPenaltyType()) + ") is not implemented.");
            }
            if (!periodPenalty.getRightTopic().equals(exam.getTopic())) continue;
            switch (periodPenalty.getPeriodPenaltyType()) {
                case EXAM_COINCIDENCE: {
                    studentSizeTotal += periodPenalty.getLeftTopic().getStudentSize();
                    maximumDuration = Math.max(maximumDuration, periodPenalty.getLeftTopic().getDuration());
                    continue block10;
                }
                case EXCLUSION: {
                    continue block10;
                }
                case AFTER: {
                    studentSizeTotal += periodPenalty.getLeftTopic().getStudentSize();
                    maximumDuration = Math.max(maximumDuration, periodPenalty.getLeftTopic().getDuration());
                    continue block10;
                }
            }
            throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenalty.getPeriodPenaltyType()) + ") is not implemented.");
        }
        return new ExamDifficultyWeight(exam, studentSizeTotal, maximumDuration);
    }

    public static class ExamDifficultyWeight
    implements Comparable<ExamDifficultyWeight> {
        private static final Comparator<ExamDifficultyWeight> COMPARATOR = Comparator.comparingInt(weight -> weight.studentSizeTotal).thenComparingInt(weight -> weight.maximumDuration).thenComparing(weight -> weight.exam instanceof LeadingExam).thenComparingLong(weight -> weight.exam.getId());
        private final Exam exam;
        private final int studentSizeTotal;
        private final int maximumDuration;

        public ExamDifficultyWeight(Exam exam, int studentSizeTotal, int maximumDuration) {
            this.exam = exam;
            this.studentSizeTotal = studentSizeTotal;
            this.maximumDuration = maximumDuration;
        }

        @Override
        public int compareTo(ExamDifficultyWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

