/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.kie.api.definition.KiePackage;
import org.kie.internal.ruleunit.RuleUnitComponentFactory;
import org.kie.internal.ruleunit.RuleUnitDescription;

public class RuleUnitDescriptionLoader {
    private RuleUnitDescriptionRegistry.State state = RuleUnitDescriptionRegistry.State.UNKNOWN;
    private final transient InternalKnowledgePackage pkg;
    private final Map<String, RuleUnitDescription> ruleUnitDescriptionsCache = new ConcurrentHashMap<String, RuleUnitDescription>();
    private final Set<String> nonExistingUnits = new HashSet<String>();

    public RuleUnitDescriptionLoader(InternalKnowledgePackage pkg) {
        this.pkg = pkg;
    }

    public RuleUnitDescriptionRegistry.State getState() {
        return this.state;
    }

    public Map<String, RuleUnitDescription> getDescriptions() {
        return this.ruleUnitDescriptionsCache;
    }

    public Optional<RuleUnitDescription> getDescription(RuleImpl rule) {
        return this.getDescription(rule.getRuleUnitClassName());
    }

    public Optional<RuleUnitDescription> getDescription(String unitClassName) {
        Optional<RuleUnitDescription> result = Optional.ofNullable(unitClassName).map(name -> this.ruleUnitDescriptionsCache.computeIfAbsent((String)name, this::findDescription));
        this.state = this.state.hasUnit(result.isPresent());
        return result;
    }

    private RuleUnitDescription findDescription(String ruleUnit) {
        if (this.nonExistingUnits.contains(ruleUnit)) {
            return null;
        }
        RuleUnitComponentFactory ruleUnitComponentFactory = RuleUnitComponentFactory.get();
        if (ruleUnitComponentFactory == null) {
            return null;
        }
        try {
            return ruleUnitComponentFactory.createRuleUnitDescription((KiePackage)this.pkg, this.pkg.getTypeResolver().resolveType(ruleUnit));
        }
        catch (ClassNotFoundException e) {
            RuleUnitDescription ruleUnitDescription = ruleUnitComponentFactory.createRuleUnitDescription((KiePackage)this.pkg, ruleUnit);
            if (ruleUnitDescription == null) {
                this.nonExistingUnits.add(ruleUnit);
                return null;
            }
            return ruleUnitDescription;
        }
    }
}

