/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.JobType;
import org.optaplanner.examples.projectjobscheduling.domain.Project;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;
import org.optaplanner.examples.projectjobscheduling.domain.resource.Resource;
import org.optaplanner.examples.projectjobscheduling.solver.score.capacity.NonrenewableResourceCapacityTracker;
import org.optaplanner.examples.projectjobscheduling.solver.score.capacity.RenewableResourceCapacityTracker;
import org.optaplanner.examples.projectjobscheduling.solver.score.capacity.ResourceCapacityTracker;

public class ProjectJobSchedulingIncrementalScoreCalculator
implements IncrementalScoreCalculator<Schedule, BendableScore> {
    private Map<Resource, ResourceCapacityTracker> resourceCapacityTrackerMap;
    private Map<Project, Integer> projectEndDateMap;
    private int maximumProjectEndDate;
    private int hardScore;
    private int soft0Score;
    private int soft1Score;

    public void resetWorkingSolution(Schedule schedule) {
        List<Resource> resourceList = schedule.getResourceList();
        this.resourceCapacityTrackerMap = new HashMap<Resource, ResourceCapacityTracker>(resourceList.size());
        for (Resource resource : resourceList) {
            this.resourceCapacityTrackerMap.put(resource, resource.isRenewable() ? new RenewableResourceCapacityTracker(resource) : new NonrenewableResourceCapacityTracker(resource));
        }
        List<Project> projectList = schedule.getProjectList();
        this.projectEndDateMap = new HashMap<Project, Integer>(projectList.size());
        this.maximumProjectEndDate = 0;
        this.hardScore = 0;
        this.soft0Score = 0;
        this.soft1Score = 0;
        int minimumReleaseDate = Integer.MAX_VALUE;
        for (Project p : projectList) {
            minimumReleaseDate = Math.min(p.getReleaseDate(), minimumReleaseDate);
        }
        this.soft1Score += minimumReleaseDate;
        for (Allocation allocation : schedule.getAllocationList()) {
            this.insert(allocation);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((Allocation)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Allocation)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Allocation)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((Allocation)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(Allocation allocation) {
        Integer endDate;
        ExecutionMode executionMode = allocation.getExecutionMode();
        if (executionMode != null && allocation.getJob().getJobType() == JobType.STANDARD) {
            for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
                ResourceCapacityTracker tracker = this.resourceCapacityTrackerMap.get(resourceRequirement.getResource());
                this.hardScore -= tracker.getHardScore();
                tracker.insert(resourceRequirement, allocation);
                this.hardScore += tracker.getHardScore();
            }
        }
        if (allocation.getJob().getJobType() == JobType.SINK && (endDate = allocation.getEndDate()) != null) {
            Project project = allocation.getProject();
            this.projectEndDateMap.put(project, endDate);
            this.soft0Score -= endDate - project.getCriticalPathEndDate();
            if (endDate > this.maximumProjectEndDate) {
                this.soft1Score -= endDate - this.maximumProjectEndDate;
                this.maximumProjectEndDate = endDate;
            }
        }
    }

    private void retract(Allocation allocation) {
        Integer endDate;
        ExecutionMode executionMode = allocation.getExecutionMode();
        if (executionMode != null && allocation.getJob().getJobType() == JobType.STANDARD) {
            for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
                ResourceCapacityTracker tracker = this.resourceCapacityTrackerMap.get(resourceRequirement.getResource());
                this.hardScore -= tracker.getHardScore();
                tracker.retract(resourceRequirement, allocation);
                this.hardScore += tracker.getHardScore();
            }
        }
        if (allocation.getJob().getJobType() == JobType.SINK && (endDate = allocation.getEndDate()) != null) {
            Project project = allocation.getProject();
            this.projectEndDateMap.remove(project);
            this.soft0Score += endDate - project.getCriticalPathEndDate();
            if (endDate == this.maximumProjectEndDate) {
                this.updateMaximumProjectEndDate();
                this.soft1Score += endDate - this.maximumProjectEndDate;
            }
        }
    }

    private void updateMaximumProjectEndDate() {
        int maximum = 0;
        for (Integer endDate : this.projectEndDateMap.values()) {
            if (endDate <= maximum) continue;
            maximum = endDate;
        }
        this.maximumProjectEndDate = maximum;
    }

    public BendableScore calculateScore() {
        return BendableScore.of((int[])new int[]{this.hardScore}, (int[])new int[]{this.soft0Score, this.soft1Score});
    }
}

