/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event.rule.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.AgendaItemImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class SerializableActivation
implements Match,
Externalizable {
    private Rule rule;
    private Declaration[] declarations;
    private List<? extends FactHandle> factHandles;
    private PropagationContext propgationContext;
    private boolean active;

    public SerializableActivation() {
    }

    public SerializableActivation(Match activation) {
        this.rule = activation.getRule();
        this.factHandles = activation.getFactHandles();
        this.propgationContext = ((Activation)activation).getPropagationContext();
        if (activation instanceof AgendaItemImpl) {
            this.declarations = ((RuleTerminalNode)((AgendaItem)activation).getTuple().getTupleSink()).getAllDeclarations();
        } else if (activation instanceof SerializableActivation) {
            this.declarations = ((SerializableActivation)activation).declarations;
        } else {
            throw new RuntimeException("Unable to get declarations " + activation);
        }
        this.active = ((Activation)activation).isQueued();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Rule getRule() {
        return this.rule;
    }

    public List<? extends FactHandle> getFactHandles() {
        return this.factHandles;
    }

    public PropagationContext getPropagationContext() {
        return this.propgationContext;
    }

    public List<Object> getObjects() {
        ArrayList<Object> objects = new ArrayList<Object>(this.factHandles.size());
        for (FactHandle factHandle : this.factHandles) {
            objects.add(((InternalFactHandle)factHandle).getObject());
        }
        return Collections.unmodifiableList(objects);
    }

    public Object getDeclarationValue(String variableName) {
        Declaration decl = ((RuleImpl)this.rule).getDeclaration(variableName);
        return decl.getValue(null, ((InternalFactHandle)this.factHandles.get(decl.getObjectIndex())).getObject());
    }

    public List<String> getDeclarationIds() {
        ArrayList<String> decls = new ArrayList<String>();
        for (Declaration decl : this.declarations) {
            decls.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(decls);
    }

    public boolean isActive() {
        return this.active;
    }
}

