/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import java.util.ArrayList;
import java.util.List;

public abstract class StatisticPoint {
    public abstract String toCsvLine();

    public static String buildCsvLineWithLongs(long timeMillisSpent, long ... values) {
        StringBuilder line = new StringBuilder(values.length * 10);
        line.append(Long.toString(timeMillisSpent));
        for (long value : values) {
            line.append(",").append(Long.toString(value));
        }
        return line.toString();
    }

    public static String buildCsvLineWithDoubles(long timeMillisSpent, double ... values) {
        StringBuilder line = new StringBuilder(values.length * 10);
        line.append(Long.toString(timeMillisSpent));
        for (double value : values) {
            line.append(",").append(Double.toString(value));
        }
        return line.toString();
    }

    public static String buildCsvLineWithStrings(long timeMillisSpent, String ... values) {
        StringBuilder line = new StringBuilder(values.length * 10);
        line.append(Long.toString(timeMillisSpent));
        for (String value : values) {
            line.append(",").append("\"").append(value.replaceAll("\"", "\"\"")).append("\"");
        }
        return line.toString();
    }

    public static String buildCsvLine(String ... values) {
        StringBuilder line = new StringBuilder(values.length * 10);
        for (String value : values) {
            line.append(",").append("\"").append(value.replaceAll("\"", "\"\"")).append("\"");
        }
        return line.substring(1).toString();
    }

    public static List<String> parseCsvLine(String line) {
        String[] tokens = line.split(",");
        ArrayList<String> csvLine = new ArrayList<String>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            while (token.trim().startsWith("\"") && !token.trim().endsWith("\"")) {
                if (++i >= tokens.length) {
                    throw new IllegalArgumentException("The CSV line (" + line + ") is not a valid CSV line.");
                }
                token = token + "," + tokens[i];
            }
            if ((token = token.trim()).startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
                token = token.replaceAll("\"\"", "\"");
            }
            csvLine.add(token);
        }
        return csvLine;
    }
}

