/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedSwapMove<Solution_>
extends SwapMove<Solution_> {
    protected final List<SingletonInverseVariableSupply> inverseVariableSupplyList;

    public ChainedSwapMove(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList, List<SingletonInverseVariableSupply> inverseVariableSupplyList, Object leftEntity, Object rightEntity) {
        super(variableDescriptorList, leftEntity, rightEntity);
        this.inverseVariableSupplyList = inverseVariableSupplyList;
    }

    @Override
    public ChainedSwapMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new ChainedSwapMove<Solution_>(this.variableDescriptorList, this.inverseVariableSupplyList, this.rightEntity, this.leftEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        for (int i = 0; i < this.variableDescriptorList.size(); ++i) {
            Object oldRightValue;
            GenuineVariableDescriptor variableDescriptor = (GenuineVariableDescriptor)this.variableDescriptorList.get(i);
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(this.rightEntity))) continue;
            if (!variableDescriptor.isChained()) {
                scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
                scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
                continue;
            }
            SingletonInverseVariableSupply inverseVariableSupply = this.inverseVariableSupplyList.get(i);
            Object oldLeftTrailingEntity = inverseVariableSupply.getInverseSingleton(this.leftEntity);
            Object oldRightTrailingEntity = inverseVariableSupply.getInverseSingleton(this.rightEntity);
            if (oldRightValue == this.leftEntity) {
                scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
                scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, this.rightEntity);
                if (oldRightTrailingEntity == null) continue;
                scoreDirector.changeVariableFacade(variableDescriptor, oldRightTrailingEntity, this.leftEntity);
                continue;
            }
            if (oldLeftValue == this.rightEntity) {
                scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
                scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, this.leftEntity);
                if (oldLeftTrailingEntity == null) continue;
                scoreDirector.changeVariableFacade(variableDescriptor, oldLeftTrailingEntity, this.rightEntity);
                continue;
            }
            scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
            scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
            if (oldRightTrailingEntity != null) {
                scoreDirector.changeVariableFacade(variableDescriptor, oldRightTrailingEntity, this.leftEntity);
            }
            if (oldLeftTrailingEntity == null) continue;
            scoreDirector.changeVariableFacade(variableDescriptor, oldLeftTrailingEntity, this.rightEntity);
        }
    }
}

