/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusHub;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.CoachShuttleGatheringSolution;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocationArc;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;

public class CoachShuttleGatheringImporter
extends AbstractTxtSolutionImporter<CoachShuttleGatheringSolution> {
    public static void main(String[] args) {
        SolutionConverter<CoachShuttleGatheringSolution> converter = SolutionConverter.createImportConverter("coachshuttlegathering", new CoachShuttleGatheringImporter(), CoachShuttleGatheringSolution.class);
        converter.convert("example", "demo01.xml");
    }

    @Override
    public boolean isInputFileDirectory() {
        return true;
    }

    @Override
    public String getInputFileSuffix() {
        throw new IllegalStateException("The inputFile is a directory, so there is no suffix.");
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<CoachShuttleGatheringSolution> createTxtInputBuilder() {
        return new CoachShuttleGatheringInputBuilder();
    }

    @Override
    public CoachShuttleGatheringSolution readSolution(File inputFile) {
        File instanceFile = new File(inputFile, "Busstops.csv");
        return (CoachShuttleGatheringSolution)super.readSolution(instanceFile);
    }

    public static class CoachShuttleGatheringInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<CoachShuttleGatheringSolution> {
        private CoachShuttleGatheringSolution solution;
        private Map<List<Double>, RoadLocation> latLongToLocationMap;
        private long busOrStopOrHubId;

        @Override
        public CoachShuttleGatheringSolution readSolution() throws IOException {
            this.solution = new CoachShuttleGatheringSolution();
            this.solution.setId(0L);
            this.readLocationList();
            this.busOrStopOrHubId = 0L;
            this.readBusList();
            this.readBusStopList();
            int busListSize = this.solution.getCoachList().size() + this.solution.getShuttleList().size();
            int base = this.solution.getStopList().size() + this.solution.getShuttleList().size();
            BigInteger a = CoachShuttleGatheringInputBuilder.factorial(base + busListSize - 1);
            BigInteger b = CoachShuttleGatheringInputBuilder.factorial(busListSize - 1);
            BigInteger possibleSolutionSize = a == null || b == null ? null : a.divide(b);
            this.logger.info("CoachShuttleGathering {} has {} road locations, {} coaches, {} shuttles and {} bus stops with a search space of {}.", new Object[]{this.getInputId(), this.solution.getLocationList().size(), this.solution.getCoachList().size(), this.solution.getShuttleList().size(), this.solution.getStopList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.solution;
        }

        @Override
        public String getInputId() {
            return FilenameUtils.getBaseName((String)this.inputFile.getParentFile().getPath());
        }

        private void readLocationList() throws IOException {
            File file = new File(this.inputFile.getParentFile(), "DistanceTimesCoordinates.csv");
            this.latLongToLocationMap = new HashMap<List<Double>, RoadLocation>();
            ArrayList<RoadLocation> locationList = new ArrayList<RoadLocation>();
            long locationId = 0L;
            try (BufferedReader subBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                subBufferedReader.readLine();
                String line = subBufferedReader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 2);
                        RoadLocation location = new RoadLocation();
                        location.setId(locationId);
                        ++locationId;
                        location.setLatitude(Double.parseDouble(lineTokens[0]));
                        location.setLongitude(Double.parseDouble(lineTokens[1]));
                        locationList.add(location);
                        this.latLongToLocationMap.put(Arrays.asList(location.getLatitude(), location.getLongitude()), location);
                    }
                    line = subBufferedReader.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read the file (" + file.getName() + ").", e);
            }
            this.solution.setLocationList(locationList);
            for (RoadLocation sourceLocation : locationList) {
                LinkedHashMap<RoadLocation, RoadLocationArc> travelDistanceMap = new LinkedHashMap<RoadLocation, RoadLocationArc>(locationList.size());
                for (RoadLocation targetLocation : locationList) {
                    travelDistanceMap.put(targetLocation, new RoadLocationArc());
                }
                sourceLocation.setTravelDistanceMap(travelDistanceMap);
            }
            this.readLocationDistancesCoaches();
            this.readLocationDistancesShuttles();
        }

        private void readLocationDistancesCoaches() throws IOException {
            List<RoadLocation> locationList = this.solution.getLocationList();
            int locationListSize = locationList.size();
            File file = new File(this.inputFile.getParentFile(), "DistanceTimesData_COACHES.csv");
            int locationListIndex = 0;
            try (BufferedReader subBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                subBufferedReader.readLine();
                String line = subBufferedReader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        RoadLocation sourceLocation = locationList.get(locationListIndex);
                        ++locationListIndex;
                        String[] lineTokens = this.splitBySemicolonSeparatedValue(line, locationListSize * 2);
                        for (int i = 0; i < locationListSize; ++i) {
                            RoadLocation targetLocation = locationList.get(i);
                            RoadLocationArc locationArc = sourceLocation.getTravelDistanceMap().get(targetLocation);
                            locationArc.setCoachDistance(Integer.parseInt(lineTokens[i * 2]));
                            locationArc.setCoachDuration(Integer.parseInt(lineTokens[i * 2 + 1]));
                        }
                    }
                    line = subBufferedReader.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read the file (" + file.getName() + ").", e);
            }
        }

        private void readLocationDistancesShuttles() throws IOException {
            List<RoadLocation> locationList = this.solution.getLocationList();
            int locationListSize = locationList.size();
            File file = new File(this.inputFile.getParentFile(), "DistanceTimesData_SHUTTLES.csv");
            int locationListIndex = 0;
            try (BufferedReader subBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                subBufferedReader.readLine();
                String line = subBufferedReader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        RoadLocation sourceLocation = locationList.get(locationListIndex);
                        ++locationListIndex;
                        String[] lineTokens = this.splitBySemicolonSeparatedValue(line, locationListSize * 2);
                        for (int i = 0; i < locationListSize; ++i) {
                            RoadLocation targetLocation = locationList.get(i);
                            RoadLocationArc locationArc = sourceLocation.getTravelDistanceMap().get(targetLocation);
                            locationArc.setShuttleDistance(Integer.parseInt(lineTokens[i * 2]));
                            locationArc.setShuttleDuration(Integer.parseInt(lineTokens[i * 2 + 1]));
                        }
                    }
                    line = subBufferedReader.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read the file (" + file.getName() + ").", e);
            }
        }

        private void readBusList() throws IOException {
            File file = new File(this.inputFile.getParentFile(), "Fleet.csv");
            ArrayList<Coach> coachList = new ArrayList<Coach>();
            ArrayList<Shuttle> shuttleList = new ArrayList<Shuttle>();
            try (BufferedReader subBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                subBufferedReader.readLine();
                String line = subBufferedReader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        Bus bus;
                        String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 8);
                        String busType = lineTokens[0];
                        String name = lineTokens[1];
                        if (busType.equalsIgnoreCase("COACH")) {
                            bus = new Coach();
                            coachList.add((Coach)bus);
                        } else if (busType.equalsIgnoreCase("SHUTTLE")) {
                            bus = new Shuttle();
                            shuttleList.add((Shuttle)bus);
                        } else {
                            throw new IllegalArgumentException("The fleet vehicle with name (" + name + ") has an unsupported type (" + busType + ").");
                        }
                        bus.setId(this.busOrStopOrHubId);
                        ++this.busOrStopOrHubId;
                        bus.setName(name);
                        bus.setCapacity(Integer.parseInt(lineTokens[2]));
                        int stopLimit = Integer.parseInt(lineTokens[3]);
                        if (bus instanceof Coach) {
                            ((Coach)bus).setStopLimit(stopLimit);
                        } else if (stopLimit != -1) {
                            throw new IllegalArgumentException("The shuttle with name (" + name + ") has an unsupported stopLimit (" + stopLimit + ").");
                        }
                        bus.setMileageCost(Integer.parseInt(lineTokens[4]));
                        int setupCost = Integer.parseInt(lineTokens[5]);
                        if (bus instanceof Coach) {
                            if (setupCost != 0) {
                                throw new IllegalArgumentException("The coach with name (" + name + ") has an unsupported setupCost (" + setupCost + ").");
                            }
                        } else {
                            ((Shuttle)bus).setSetupCost(setupCost);
                        }
                        double latitude = Double.parseDouble(lineTokens[6]);
                        double longitude = Double.parseDouble(lineTokens[7]);
                        RoadLocation location = this.latLongToLocationMap.get(Arrays.asList(latitude, longitude));
                        if (location == null) {
                            throw new IllegalArgumentException("The fleet vehicle with name (" + name + ") has a coordinate (" + latitude + ", " + longitude + ") which is not in the coordinates file.");
                        }
                        bus.setDepartureLocation(location);
                    }
                    line = subBufferedReader.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read the file (" + file.getName() + ").", e);
            }
            this.solution.setCoachList(coachList);
            this.solution.setShuttleList(shuttleList);
        }

        private void readBusStopList() throws IOException {
            ArrayList<BusStop> busStopList = new ArrayList<BusStop>();
            this.bufferedReader.readLine();
            String line = this.bufferedReader.readLine();
            while (line != null) {
                if (!line.isEmpty()) {
                    RoadLocation location;
                    double longitude;
                    double latitude;
                    String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 8);
                    String busStopType = lineTokens[0];
                    String name = lineTokens[1];
                    if (busStopType.equalsIgnoreCase("HUB")) {
                        if (this.solution.getHub() != null) {
                            throw new IllegalArgumentException("The hub with name (" + name + ") is not the only hub (" + this.solution.getHub().getName() + ").");
                        }
                        BusHub hub = new BusHub();
                        hub.setId(this.busOrStopOrHubId);
                        ++this.busOrStopOrHubId;
                        hub.setName(name);
                        latitude = Double.parseDouble(lineTokens[4]);
                        longitude = Double.parseDouble(lineTokens[5]);
                        location = this.latLongToLocationMap.get(Arrays.asList(latitude, longitude));
                        if (location == null) {
                            throw new IllegalArgumentException("The bus stop with name (" + name + ") has a coordinate (" + latitude + ", " + longitude + ") which is not in the coordinates file.");
                        }
                        hub.setLocation(location);
                        int passengerQuantity = Integer.parseInt(lineTokens[6]);
                        if (passengerQuantity != 0) {
                            throw new IllegalArgumentException("The hub with name (" + name + ") has an unsupported passengerQuantity (" + passengerQuantity + ").");
                        }
                        int transportTimeLimit = Integer.parseInt(lineTokens[7]);
                        if (transportTimeLimit != 0) {
                            throw new IllegalArgumentException("The hub with name (" + name + ") has an unsupported transportTimeLimit (" + transportTimeLimit + ").");
                        }
                        for (Coach coach : this.solution.getCoachList()) {
                            coach.setDestination(hub);
                        }
                        ArrayList<Shuttle> transferShuttleList = new ArrayList<Shuttle>(this.solution.getShuttleList().size());
                        for (Shuttle shuttle : this.solution.getShuttleList()) {
                            shuttle.setDestination(hub);
                            transferShuttleList.add(shuttle);
                        }
                        hub.setTransferShuttleList(transferShuttleList);
                        this.solution.setHub(hub);
                    } else if (busStopType.equalsIgnoreCase("BUSSTOP")) {
                        BusStop busStop = new BusStop();
                        busStop.setId(this.busOrStopOrHubId);
                        ++this.busOrStopOrHubId;
                        busStop.setName(name);
                        latitude = Double.parseDouble(lineTokens[4]);
                        longitude = Double.parseDouble(lineTokens[5]);
                        location = this.latLongToLocationMap.get(Arrays.asList(latitude, longitude));
                        if (location == null) {
                            throw new IllegalArgumentException("The bus stop with name (" + name + ") has a coordinate (" + latitude + ", " + longitude + ") which is not in the coordinates file.");
                        }
                        busStop.setLocation(location);
                        busStop.setPassengerQuantity(Integer.parseInt(lineTokens[6]));
                        busStop.setTransportTimeLimit(Integer.parseInt(lineTokens[7]));
                        busStop.setTransferShuttleList(new ArrayList<Shuttle>(this.solution.getShuttleList().size()));
                        busStopList.add(busStop);
                    } else {
                        throw new IllegalArgumentException("The bus stop with name (" + name + ") has an unsupported type (" + busStopType + ").");
                    }
                }
                line = this.bufferedReader.readLine();
            }
            this.solution.setStopList(busStopList);
        }
    }
}

