/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.awt.Component;
import java.io.File;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.swing.impl.SwingUncaughtExceptionHandler;
import org.optaplanner.swing.impl.SwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonApp<Solution_>
extends LoggingMain {
    public static final String DATA_DIR_SYSTEM_PROPERTY = "org.optaplanner.examples.dataDir";
    protected static final Logger logger = LoggerFactory.getLogger(CommonApp.class);
    protected final String name;
    protected final String description;
    protected final String solverConfig;
    protected final String dataDirName;
    protected final String iconResource;
    protected SolverAndPersistenceFrame<Solution_> solverAndPersistenceFrame;
    protected SolutionBusiness<Solution_> solutionBusiness;

    public static File determineDataDir(String dataDirName) {
        String dataDirPath = System.getProperty(DATA_DIR_SYSTEM_PROPERTY, "data/");
        File dataDir = new File(dataDirPath, dataDirName);
        if (!dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + dataDir.getAbsolutePath() + ") does not exist.\n Either the working directory should be set to the directory that contains the data directory (which is not the data directory itself), or the system property " + DATA_DIR_SYSTEM_PROPERTY + " should be set properly.\n The data directory is different in a git clone (optaplanner/optaplanner-examples/data) and in a release zip (examples/sources/data).\n In an IDE (IntelliJ, Eclipse, NetBeans), open the \"Run configuration\" to change \"Working directory\" (or add the system property in \"VM options\").");
        }
        return dataDir;
    }

    public static void prepareSwingEnvironment() {
        SwingUncaughtExceptionHandler.register();
        SwingUtils.fixateLookAndFeel();
    }

    protected CommonApp(String name, String description, String solverConfig, String dataDirName, String iconResource) {
        this.name = name;
        this.description = description;
        this.solverConfig = solverConfig;
        this.dataDirName = dataDirName;
        this.iconResource = iconResource;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSolverConfig() {
        return this.solverConfig;
    }

    public String getDataDirName() {
        return this.dataDirName;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void init() {
        this.init(null, true);
    }

    public void init(Component centerForComponent, boolean exitOnClose) {
        this.solutionBusiness = this.createSolutionBusiness();
        this.solverAndPersistenceFrame = new SolverAndPersistenceFrame<Solution_>(this.solutionBusiness, this.createSolutionPanel());
        this.solverAndPersistenceFrame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        this.solverAndPersistenceFrame.init(centerForComponent);
        this.solverAndPersistenceFrame.setVisible(true);
    }

    public SolutionBusiness<Solution_> createSolutionBusiness() {
        SolutionBusiness<Solution_> solutionBusiness = new SolutionBusiness<Solution_>(this);
        solutionBusiness.setSolver(this.createSolver());
        solutionBusiness.setDataDir(CommonApp.determineDataDir(this.dataDirName));
        solutionBusiness.setSolutionFileIO(this.createSolutionFileIO());
        solutionBusiness.setImporters(this.createSolutionImporters());
        solutionBusiness.setExporter(this.createSolutionExporter());
        solutionBusiness.updateDataDirs();
        return solutionBusiness;
    }

    protected Solver<Solution_> createSolver() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.solverConfig);
        return solverFactory.buildSolver();
    }

    protected abstract SolutionPanel<Solution_> createSolutionPanel();

    public abstract SolutionFileIO<Solution_> createSolutionFileIO();

    protected AbstractSolutionImporter[] createSolutionImporters() {
        return new AbstractSolutionImporter[0];
    }

    protected AbstractSolutionExporter createSolutionExporter() {
        return null;
    }
}

