/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceParametrization;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.swing.impl.TangoColorFactory;

public class ConferenceSchedulingXslxFileIO
implements SolutionFileIO<ConferenceSolution> {
    protected static final Pattern VALID_TAG_PATTERN;
    protected static final Pattern VALID_NAME_PATTERN;
    protected static final Pattern VALID_CODE_PATTERN;
    protected static final DateTimeFormatter DAY_FORMATTER;
    protected static final DateTimeFormatter TIME_FORMATTER;
    protected static final XSSFColor VIEW_TAB_COLOR;
    protected static final XSSFColor UNAVAILABLE_COLOR;
    protected static final XSSFColor PINNED_COLOR;
    protected static final XSSFColor HARD_PENALTY_COLOR;
    protected static final XSSFColor SOFT_PENALTY_COLOR;

    public String getInputFileExtension() {
        return "xlsx";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConferenceSolution read(File inputSolutionFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputSolutionFile));){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            ConferenceSolution conferenceSolution = new ConferenceSchedulingXslxReader(workbook).read();
            return conferenceSolution;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(ConferenceSolution solution, File outputSolutionFile) {
        try (FileOutputStream out = new FileOutputStream(outputSolutionFile);){
            Workbook workbook = new ConferenceSchedulingXlsxWriter(solution).write();
            workbook.write((OutputStream)out);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed writing outputSolutionFile (" + outputSolutionFile + ") for solution (" + solution + ").", e);
        }
    }

    static {
        VALID_NAME_PATTERN = VALID_TAG_PATTERN = Pattern.compile("(?U)^[\\w\\d _&\\-\\.\\(\\)]+$");
        VALID_CODE_PATTERN = Pattern.compile("(?U)^[\\w\\d_\\-\\.\\(\\)]+$");
        DAY_FORMATTER = DateTimeFormatter.ofPattern("E yyyy-MM-dd", Locale.ENGLISH);
        TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm", Locale.ENGLISH);
        VIEW_TAB_COLOR = new XSSFColor(TangoColorFactory.BUTTER_1);
        UNAVAILABLE_COLOR = new XSSFColor(TangoColorFactory.ALUMINIUM_5);
        PINNED_COLOR = new XSSFColor(TangoColorFactory.PLUM_1);
        HARD_PENALTY_COLOR = new XSSFColor(TangoColorFactory.SCARLET_1);
        SOFT_PENALTY_COLOR = new XSSFColor(TangoColorFactory.ORANGE_1);
    }

    private static class ConferenceSchedulingXlsxWriter {
        protected final ConferenceSolution solution;
        protected final Map<Object, Indictment> indictmentMap;
        protected XSSFWorkbook workbook;
        protected CreationHelper creationHelper;
        protected XSSFCellStyle headerStyle;
        protected XSSFCellStyle defaultStyle;
        protected XSSFCellStyle unavailableStyle;
        protected XSSFCellStyle pinnedStyle;
        protected XSSFCellStyle hardPenaltyStyle;
        protected XSSFCellStyle softPenaltyStyle;
        protected XSSFCellStyle wrappedStyle;
        protected XSSFSheet currentSheet;
        protected Drawing currentDrawing;
        protected XSSFRow currentRow;
        protected int currentRowNumber;
        protected int currentColumnNumber;
        protected int headerCellCount;

        public ConferenceSchedulingXlsxWriter(ConferenceSolution solution) {
            this.solution = solution;
            ScoreDirectorFactory scoreDirectorFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml").buildSolver().getScoreDirectorFactory();
            try (ScoreDirector scoreDirector = scoreDirectorFactory.buildScoreDirector();){
                scoreDirector.setWorkingSolution((Object)solution);
                scoreDirector.calculateScore();
                this.indictmentMap = scoreDirector.getIndictmentMap();
            }
        }

        public Workbook write() {
            this.workbook = new XSSFWorkbook();
            this.creationHelper = this.workbook.getCreationHelper();
            this.createStyles();
            this.writeConfiguration();
            this.writeTimeslotList();
            this.writeRoomList();
            this.writeSpeakerList();
            this.writeTalkList();
            this.writeRoomsView();
            this.writeSpeakersView();
            this.writeThemeTracksView();
            this.writeSectorsView();
            this.writeContentsView();
            return this.workbook;
        }

        public void createStyles() {
            this.headerStyle = this.createStyle(null);
            XSSFFont font = this.workbook.createFont();
            font.setBold(true);
            this.headerStyle.setFont((Font)font);
            this.defaultStyle = this.createStyle(null);
            this.unavailableStyle = this.createStyle(UNAVAILABLE_COLOR);
            this.pinnedStyle = this.createStyle(PINNED_COLOR);
            this.hardPenaltyStyle = this.createStyle(HARD_PENALTY_COLOR);
            this.softPenaltyStyle = this.createStyle(SOFT_PENALTY_COLOR);
            this.wrappedStyle = this.createStyle(null);
        }

        private XSSFCellStyle createStyle(XSSFColor color) {
            XSSFCellStyle style = this.workbook.createCellStyle();
            if (color != null) {
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(color);
            }
            style.setWrapText(true);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            return style;
        }

        private void writeConfiguration() {
            this.nextSheet("Configuration", 1, 3, false);
            this.nextRow();
            this.nextHeaderCell("Conference name");
            this.nextCell().setCellValue(this.solution.getConferenceName());
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Constraint");
            this.nextHeaderCell("Weight");
            this.nextHeaderCell("Description");
            ConferenceParametrization parametrization = this.solution.getParametrization();
            this.writeConstraintLine("Theme track conflict", parametrization::getThemeTrackConflict, "Soft penalty per common theme track of 2 talks that have an overlapping timeslot");
            this.writeConstraintLine("Sector conflict", parametrization::getSectorConflict, "Soft penalty per common sector of 2 talks that have an overlapping timeslot");
            this.writeConstraintLine("Content audience level flow violation", parametrization::getContentAudienceLevelFlowViolation, "Soft penalty per common content of 2 talks with a different audience level for which the easier talk isn't scheduled earlier than the other talk");
            this.writeConstraintLine("Audience level diversity", parametrization::getAudienceLevelDiversity, "Soft reward per 2 talks that have the same timeslot and a different audience level");
            this.writeConstraintLine("Language diversity", parametrization::getLanguageDiversity, "Soft reward per 2 talks that have the same timeslot and a different language");
            this.writeConstraintLine("Speaker preferred timeslot tag", parametrization::getSpeakerPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.writeConstraintLine("Speaker undesired timeslot tag", parametrization::getSpeakerUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.writeConstraintLine("Talk preferred timeslot tag", parametrization::getTalkPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.writeConstraintLine("Talk undesired timeslot tag", parametrization::getTalkUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.writeConstraintLine("Speaker preferred room tag", parametrization::getSpeakerPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.writeConstraintLine("Speaker undesired room tag", parametrization::getSpeakerUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.writeConstraintLine("Talk preferred room tag", parametrization::getTalkPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.writeConstraintLine("Talk undesired room tag", parametrization::getTalkUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.nextRow();
            this.writeConstraintLine("Talk type of timeslot", null, "Hard penalty per talk in a timeslot with an other talk type");
            this.writeConstraintLine("Room unavailable timeslot", null, "Hard penalty per talk with an unavailable room at its timeslot");
            this.writeConstraintLine("Room conflict", null, "Hard penalty per pair of talks in the same room in overlapping timeslots");
            this.writeConstraintLine("Speaker unavailable timeslot", null, "Hard penalty per talk with an unavailable speaker at its timeslot");
            this.writeConstraintLine("Speaker conflict", null, "Hard penalty per pair of talks with the same speaker in overlapping timeslots");
            this.writeConstraintLine("Speaker required timeslot tag", null, "Hard penalty per missing required tag in a talk's timeslot");
            this.writeConstraintLine("Speaker prohibited timeslot tag", null, "Hard penalty per prohibited tag in a talk's timeslot");
            this.writeConstraintLine("Talk required timeslot tag", null, "Hard penalty per missing required tag in a talk's timeslot");
            this.writeConstraintLine("Talk prohibited timeslot tag", null, "Hard penalty per prohibited tag in a talk's timeslot");
            this.writeConstraintLine("Speaker required room tag", null, "Hard penalty per missing required tag in a talk's room");
            this.writeConstraintLine("Speaker prohibited room tag", null, "Hard penalty per prohibited tag in a talk's room");
            this.writeConstraintLine("Talk required room tag", null, "Hard penalty per missing required tag in a talk's room");
            this.writeConstraintLine("Talk prohibited room tag", null, "Hard penalty per prohibited tag in a talk's room");
            this.autoSizeColumnsWithHeader();
        }

        private void writeConstraintLine(String name, Supplier<Integer> supplier, String constraintdescription) {
            this.nextRow();
            this.nextHeaderCell(name);
            XSSFCell weightCell = this.nextCell();
            if (supplier != null) {
                weightCell.setCellValue((double)supplier.get().intValue());
            } else {
                weightCell.setCellValue("n/a");
            }
            this.nextHeaderCell(constraintdescription);
        }

        private void writeTimeslotList() {
            this.nextSheet("Timeslots", 3, 1, false);
            this.nextRow();
            this.nextHeaderCell("Day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Talk type");
            this.nextHeaderCell("Tags");
            for (Timeslot timeslot : this.solution.getTimeslotList()) {
                this.nextRow();
                this.nextCell().setCellValue(DAY_FORMATTER.format(timeslot.getDate()));
                this.nextCell().setCellValue(TIME_FORMATTER.format(timeslot.getStartDateTime()));
                this.nextCell().setCellValue(TIME_FORMATTER.format(timeslot.getEndDateTime()));
                this.nextCell().setCellValue(timeslot.getTalkType());
                this.nextCell().setCellValue(String.join((CharSequence)", ", timeslot.getTagSet()));
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomList() {
            this.nextSheet("Rooms", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Tags");
            this.writeTimeslotHoursHeaders();
            for (Room room : this.solution.getRoomList()) {
                this.nextRow();
                this.nextCell().setCellValue(room.getName());
                this.nextCell().setCellValue(String.join((CharSequence)", ", room.getTagSet()));
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    this.nextCell(room.getUnavailableTimeslotSet().contains(timeslot) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeSpeakerList() {
            this.nextSheet("Speakers", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Required timeslot tags");
            this.nextHeaderCell("Preferred timeslot tags");
            this.nextHeaderCell("Prohibited timeslot tags");
            this.nextHeaderCell("Undesired timeslot tags");
            this.nextHeaderCell("Required room tags");
            this.nextHeaderCell("Preferred room tags");
            this.nextHeaderCell("Prohibited room tags");
            this.nextHeaderCell("Undesired room tags");
            this.writeTimeslotHoursHeaders();
            for (Speaker speaker : this.solution.getSpeakerList()) {
                this.nextRow();
                this.nextCell().setCellValue(speaker.getName());
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getRequiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getPreferredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getProhibitedTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getUndesiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getRequiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getPreferredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getProhibitedRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getUndesiredRoomTagSet()));
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    this.nextCell(speaker.getUnavailableTimeslotSet().contains(timeslot) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeTalkList() {
            this.nextSheet("Talks", 2, 1, false);
            this.nextRow();
            this.nextHeaderCell("Code");
            this.nextHeaderCell("Title");
            this.nextHeaderCell("Talk type");
            this.nextHeaderCell("Speakers");
            this.nextHeaderCell("Theme track tags");
            this.nextHeaderCell("Sector tags");
            this.nextHeaderCell("Audience level");
            this.nextHeaderCell("Content tags");
            this.nextHeaderCell("Language");
            this.nextHeaderCell("Required timeslot tags");
            this.nextHeaderCell("Preferred timeslot tags");
            this.nextHeaderCell("Prohibited timeslot tags");
            this.nextHeaderCell("Undesired timeslot tags");
            this.nextHeaderCell("Required room tags");
            this.nextHeaderCell("Preferred room tags");
            this.nextHeaderCell("Prohibited room tags");
            this.nextHeaderCell("Undesired room tags");
            this.nextHeaderCell("Pinned by user");
            this.nextHeaderCell("Timeslot day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Room");
            for (Talk talk : this.solution.getTalkList()) {
                this.nextRow();
                this.nextCell().setCellValue(talk.getCode());
                this.nextCell().setCellValue(talk.getTitle());
                this.nextCell().setCellValue(talk.getTalkType());
                this.nextCell().setCellValue(talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getThemeTrackTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getSectorTagSet()));
                this.nextCell().setCellValue((double)talk.getAudienceLevel());
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getContentTagSet()));
                this.nextCell().setCellValue(talk.getLanguage());
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getRequiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPreferredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getProhibitedTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getUndesiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getRequiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPreferredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getProhibitedRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getUndesiredRoomTagSet()));
                this.nextCell(talk.isPinnedByUser() ? this.pinnedStyle : this.defaultStyle).setCellValue(talk.isPinnedByUser());
                this.nextCell().setCellValue(talk.getTimeslot() == null ? "" : DAY_FORMATTER.format(talk.getTimeslot().getDate()));
                this.nextCell().setCellValue(talk.getTimeslot() == null ? "" : TIME_FORMATTER.format(talk.getTimeslot().getStartDateTime()));
                this.nextCell().setCellValue(talk.getTimeslot() == null ? "" : TIME_FORMATTER.format(talk.getTimeslot().getEndDateTime()));
                this.nextCell().setCellValue(talk.getRoom() == null ? "" : talk.getRoom().getName());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomsView() {
            this.nextSheet("Rooms view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Room");
            this.writeTimeslotHoursHeaders();
            for (Room room : this.solution.getRoomList()) {
                this.nextRow();
                this.currentRow.setHeightInPoints(2.0f * this.currentSheet.getDefaultRowHeightInPoints());
                this.nextCell().setCellValue(room.getName());
                List roomTalkList = this.solution.getTalkList().stream().filter(talk -> talk.getRoom() == room).collect(Collectors.toList());
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    List<Talk> talkList = roomTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                    boolean unavailable = room.getUnavailableTimeslotSet().contains(timeslot);
                    this.nextTalkListCell(unavailable, talkList, talk -> talk.getCode() + ": " + talk.getTitle());
                }
            }
            this.currentSheet.autoSizeColumn(0);
            for (int i = 1; i < this.headerCellCount; ++i) {
                this.currentSheet.setColumnWidth(i, 5120);
            }
        }

        private void writeSpeakersView() {
            this.nextSheet("Speakers view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Speaker");
            this.writeTimeslotHoursHeaders();
            for (Speaker speaker : this.solution.getSpeakerList()) {
                this.nextRow();
                this.nextCell().setCellValue(speaker.getName());
                List timeslotTalkList = this.solution.getTalkList().stream().filter(talk -> talk.getSpeakerList().contains(speaker)).collect(Collectors.toList());
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    List<Talk> talkList = timeslotTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                    boolean unavailable = speaker.getUnavailableTimeslotSet().contains(timeslot);
                    this.nextTalkListCell(unavailable, talkList);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeThemeTracksView() {
            this.nextSheet("Theme tracks view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Theme track tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = this.solution.getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getThemeTrackTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeSectorsView() {
            this.nextSheet("Sectors view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Sector tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = this.solution.getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getSectorTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeContentsView() {
            this.nextSheet("Contents view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Content tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = this.solution.getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getContentTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, (Talk talk) -> talk.getCode() + " (level " + talk.getAudienceLevel() + ")");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeTimeslotDaysHeaders() {
            LocalDate previousTimeslotDay = null;
            int mergeStart = -1;
            for (Timeslot timeslot : this.solution.getTimeslotList()) {
                LocalDate timeslotDay = timeslot.getDate();
                if (timeslotDay.equals(previousTimeslotDay)) {
                    this.nextHeaderCell("");
                    continue;
                }
                if (previousTimeslotDay != null) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                }
                this.nextHeaderCell(DAY_FORMATTER.format(timeslotDay));
                previousTimeslotDay = timeslotDay;
                mergeStart = this.currentColumnNumber;
            }
            if (previousTimeslotDay != null) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
        }

        private void writeTimeslotHoursHeaders() {
            for (Timeslot timeslot : this.solution.getTimeslotList()) {
                this.nextHeaderCell(TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + TIME_FORMATTER.format(timeslot.getEndDateTime()));
            }
        }

        protected void nextSheet(String sheetName, int colSplit, int rowSplit, boolean view) {
            this.currentSheet = this.workbook.createSheet(sheetName);
            this.currentDrawing = this.currentSheet.createDrawingPatriarch();
            this.currentSheet.createFreezePane(colSplit, rowSplit);
            this.currentRowNumber = -1;
            this.headerCellCount = 0;
            if (view) {
                this.currentSheet.setTabColor(VIEW_TAB_COLOR);
            }
        }

        protected void nextRow() {
            ++this.currentRowNumber;
            this.currentRow = this.currentSheet.createRow(this.currentRowNumber);
            this.currentColumnNumber = -1;
        }

        protected void nextHeaderCell(String value) {
            this.nextCell(this.headerStyle).setCellValue(value);
            ++this.headerCellCount;
        }

        protected void nextTalkListCell(List<Talk> talkList) {
            this.nextTalkListCell(false, talkList, Talk::getCode);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList) {
            this.nextTalkListCell(unavailable, talkList, Talk::getCode);
        }

        protected void nextTalkListCell(List<Talk> talkList, Function<Talk, String> stringFunction) {
            this.nextTalkListCell(false, talkList, stringFunction);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, Function<Talk, String> stringFunction) {
            if (talkList == null) {
                talkList = Collections.emptyList();
            }
            List indictmentList = talkList.stream().map(this.indictmentMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            HardSoftScore score = indictmentList.stream().flatMap(indictment -> indictment.getConstraintMatchSet().stream()).map(tConstraintMatch -> (HardSoftScore)tConstraintMatch.getScore()).filter(indictmentScore -> indictmentScore.getHardScore() < 0 || indictmentScore.getSoftScore() < 0).reduce(Score::add).orElse(HardSoftScore.ZERO);
            XSSFCell cell = talkList.stream().anyMatch(Talk::isPinnedByUser) ? this.nextCell(this.pinnedStyle) : (!score.isFeasible() ? this.nextCell(this.hardPenaltyStyle) : (unavailable ? this.nextCell(this.unavailableStyle) : (score.getSoftScore() < 0 ? this.nextCell(this.softPenaltyStyle) : this.nextCell(this.wrappedStyle))));
            if (!talkList.isEmpty()) {
                ClientAnchor anchor = this.creationHelper.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 5);
                anchor.setRow1(this.currentRow.getRowNum());
                anchor.setRow2(this.currentRow.getRowNum() + 5);
                Comment comment = this.currentDrawing.createCellComment(anchor);
                String commentString = talkList.stream().map(talk -> talk.getCode() + ": " + talk.getTitle() + "\n  " + talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")) + (talk.isPinnedByUser() ? "\n  PINNED BY USER" : "")).collect(Collectors.joining("\n\n"));
                if (!indictmentList.isEmpty()) {
                    commentString = commentString + "\n\nConstraint matches:\n  " + indictmentList.stream().flatMap(indictment -> indictment.getConstraintMatchSet().stream()).map(constraintMatch -> constraintMatch.getConstraintName() + " (" + constraintMatch.getJustificationList().stream().filter(o -> o instanceof Talk).map(o -> ((Talk)o).getCode()).collect(Collectors.joining(", ")) + "): " + constraintMatch.getScore().toShortString()).collect(Collectors.joining("\n  "));
                }
                comment.setString(this.creationHelper.createRichTextString(commentString));
                cell.setCellComment(comment);
            }
            cell.setCellValue(talkList.stream().map(stringFunction).collect(Collectors.joining("\n")));
            this.currentRow.setHeightInPoints(Math.max(this.currentRow.getHeightInPoints(), (float)talkList.size() * this.currentSheet.getDefaultRowHeightInPoints()));
        }

        protected XSSFCell nextCell() {
            return this.nextCell(this.defaultStyle);
        }

        protected XSSFCell nextCell(XSSFCellStyle cellStyle) {
            ++this.currentColumnNumber;
            XSSFCell cell = this.currentRow.createCell(this.currentColumnNumber);
            cell.setCellStyle((CellStyle)cellStyle);
            return cell;
        }

        protected void autoSizeColumnsWithHeader() {
            for (int i = 0; i < this.headerCellCount; ++i) {
                this.currentSheet.autoSizeColumn(i);
            }
        }
    }

    private static class ConferenceSchedulingXslxReader {
        protected final XSSFWorkbook workbook;
        protected ConferenceSolution solution;
        private Set<String> totalTalkTypeSet;
        private Set<String> totalTimeslotTagSet;
        private Set<String> totalRoomTagSet;
        protected XSSFSheet currentSheet;
        protected Iterator<Row> currentRowIterator;
        protected XSSFRow currentRow;
        protected int currentRowNumber;
        protected int currentColumnNumber;

        public ConferenceSchedulingXslxReader(XSSFWorkbook workbook) {
            this.workbook = workbook;
        }

        public ConferenceSolution read() {
            this.solution = new ConferenceSolution();
            this.totalTalkTypeSet = new HashSet<String>();
            this.totalTimeslotTagSet = new HashSet<String>();
            this.totalRoomTagSet = new HashSet<String>();
            this.readConfiguration();
            this.readTimeslotList();
            this.readRoomList();
            this.readSpeakerList();
            this.readTalkList();
            return this.solution;
        }

        private void readConfiguration() {
            this.nextSheet("Configuration");
            this.nextRow();
            this.readHeaderCell("Conference name");
            this.solution.setConferenceName(this.nextCell().getStringCellValue());
            if (!VALID_NAME_PATTERN.matcher(this.solution.getConferenceName()).matches()) {
                throw new IllegalStateException(this.currentPosition() + ": The conference name (" + this.solution.getConferenceName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
            }
            this.nextRow(true);
            this.readHeaderCell("Constraint");
            this.readHeaderCell("Weight");
            this.readHeaderCell("Description");
            ConferenceParametrization parametrization = new ConferenceParametrization();
            parametrization.setId(0L);
            this.readConstraintLine("Theme track conflict", parametrization::setThemeTrackConflict, "Soft penalty per common theme track of 2 talks that have an overlapping timeslot");
            this.readConstraintLine("Sector conflict", parametrization::setSectorConflict, "Soft penalty per common sector of 2 talks that have an overlapping timeslot");
            this.readConstraintLine("Content audience level flow violation", parametrization::setContentAudienceLevelFlowViolation, "Soft penalty per common content of 2 talks with a different audience level for which the easier talk isn't scheduled earlier than the other talk");
            this.readConstraintLine("Audience level diversity", parametrization::setAudienceLevelDiversity, "Soft reward per 2 talks that have the same timeslot and a different audience level");
            this.readConstraintLine("Language diversity", parametrization::setLanguageDiversity, "Soft reward per 2 talks that have the same timeslot and a different language");
            this.readConstraintLine("Speaker preferred timeslot tag", parametrization::setSpeakerPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.readConstraintLine("Speaker undesired timeslot tag", parametrization::setSpeakerUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.readConstraintLine("Talk preferred timeslot tag", parametrization::setTalkPreferredTimeslotTag, "Soft penalty per missing preferred tag in a talk's timeslot");
            this.readConstraintLine("Talk undesired timeslot tag", parametrization::setTalkUndesiredTimeslotTag, "Soft penalty per undesired tag in a talk's timeslot");
            this.readConstraintLine("Speaker preferred room tag", parametrization::setSpeakerPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.readConstraintLine("Speaker undesired room tag", parametrization::setSpeakerUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.readConstraintLine("Talk preferred room tag", parametrization::setTalkPreferredRoomTag, "Soft penalty per missing preferred tag in a talk's room");
            this.readConstraintLine("Talk undesired room tag", parametrization::setTalkUndesiredRoomTag, "Soft penalty per undesired tag in a talk's room");
            this.solution.setParametrization(parametrization);
        }

        private void readConstraintLine(String name, Consumer<Integer> consumer, String constraintdescription) {
            this.nextRow();
            this.readHeaderCell(name);
            XSSFCell weightCell = this.nextCell();
            if (consumer != null) {
                double value = weightCell.getNumericCellValue();
                if ((double)((int)value) != value) {
                    throw new IllegalArgumentException(this.currentPosition() + ": The value (" + value + ") for constraint (" + name + ") must be an integer.");
                }
                consumer.accept((int)value);
            } else if (!weightCell.getStringCellValue().equals("n/a")) {
                throw new IllegalArgumentException(this.currentPosition() + ": The value (" + weightCell.getStringCellValue() + ") for constraint (" + name + ") must be an n/a.");
            }
            this.readHeaderCell(constraintdescription);
        }

        private void readTimeslotList() {
            this.nextSheet("Timeslots");
            this.nextRow(false);
            this.readHeaderCell("Day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            this.readHeaderCell("Talk type");
            this.readHeaderCell("Tags");
            ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Timeslot timeslot = new Timeslot();
                timeslot.setId(id++);
                LocalDate day = LocalDate.parse(this.nextCell().getStringCellValue(), DAY_FORMATTER);
                LocalTime startTime = LocalTime.parse(this.nextCell().getStringCellValue(), TIME_FORMATTER);
                LocalTime endTime = LocalTime.parse(this.nextCell().getStringCellValue(), TIME_FORMATTER);
                if (startTime.compareTo(endTime) >= 0) {
                    throw new IllegalStateException(this.currentPosition() + ": The startTime (" + startTime + ") must be less than the endTime (" + endTime + ").");
                }
                timeslot.setStartDateTime(LocalDateTime.of(day, startTime));
                timeslot.setEndDateTime(LocalDateTime.of(day, endTime));
                timeslot.setTalkType(this.nextCell().getStringCellValue());
                if (timeslot.getTalkType().isEmpty()) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk type (" + timeslot.getTalkType() + ") must not be empty.");
                }
                this.totalTalkTypeSet.add(timeslot.getTalkType());
                timeslot.setTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : timeslot.getTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                this.totalTimeslotTagSet.addAll(timeslot.getTagSet());
                timeslotList.add(timeslot);
            }
            this.solution.setTimeslotList(timeslotList);
        }

        private void readRoomList() {
            this.nextSheet("Rooms");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readTimeslotDaysHeaders();
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Tags");
            this.readTimeslotHoursHeaders();
            ArrayList<Room> roomList = new ArrayList<Room>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Room room = new Room();
                room.setId(id++);
                room.setName(this.nextCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(room.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The room name (" + room.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                room.setTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : room.getTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The room (" + room + ")'s tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                this.totalRoomTagSet.addAll(room.getTagSet());
                LinkedHashSet<Timeslot> unavailableTimeslotSet = new LinkedHashSet<Timeslot>();
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    XSSFCell cell = this.nextCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableTimeslotSet.add(timeslot);
                    }
                    if (cell.getStringCellValue().isEmpty()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty. Use the talks sheet pre-assign rooms and timeslots.");
                }
                room.setUnavailableTimeslotSet(unavailableTimeslotSet);
                roomList.add(room);
            }
            this.solution.setRoomList(roomList);
        }

        private void readSpeakerList() {
            this.nextSheet("Speakers");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readTimeslotDaysHeaders();
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Required timeslot tags");
            this.readHeaderCell("Preferred timeslot tags");
            this.readHeaderCell("Prohibited timeslot tags");
            this.readHeaderCell("Undesired timeslot tags");
            this.readHeaderCell("Required room tags");
            this.readHeaderCell("Preferred room tags");
            this.readHeaderCell("Prohibited room tags");
            this.readHeaderCell("Undesired room tags");
            this.readTimeslotHoursHeaders();
            ArrayList<Speaker> speakerList = new ArrayList<Speaker>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Speaker speaker = new Speaker();
                speaker.setId(id++);
                speaker.setName(this.nextCell().getStringCellValue());
                if (!VALID_NAME_PATTERN.matcher(speaker.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The speaker name (" + speaker.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                speaker.setRequiredTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getRequiredTimeslotTagSet());
                speaker.setPreferredTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getPreferredTimeslotTagSet());
                speaker.setProhibitedTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getProhibitedTimeslotTagSet());
                speaker.setUndesiredTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getUndesiredTimeslotTagSet());
                speaker.setRequiredRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getRequiredRoomTagSet());
                speaker.setPreferredRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getPreferredRoomTagSet());
                speaker.setProhibitedRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getProhibitedRoomTagSet());
                speaker.setUndesiredRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getUndesiredRoomTagSet());
                LinkedHashSet<Timeslot> unavailableTimeslotSet = new LinkedHashSet<Timeslot>();
                for (Timeslot timeslot : this.solution.getTimeslotList()) {
                    XSSFCell cell = this.nextCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableTimeslotSet.add(timeslot);
                    }
                    if (cell.getStringCellValue().isEmpty()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty. Use the talks sheet pre-assign rooms and timeslots.");
                }
                speaker.setUnavailableTimeslotSet(unavailableTimeslotSet);
                speakerList.add(speaker);
            }
            this.solution.setSpeakerList(speakerList);
        }

        private void readTalkList() {
            Map<String, Speaker> speakerMap = this.solution.getSpeakerList().stream().collect(Collectors.toMap(Speaker::getName, speaker -> speaker));
            this.nextSheet("Talks");
            this.nextRow(false);
            this.readHeaderCell("Code");
            this.readHeaderCell("Title");
            this.readHeaderCell("Talk type");
            this.readHeaderCell("Speakers");
            this.readHeaderCell("Theme track tags");
            this.readHeaderCell("Sector tags");
            this.readHeaderCell("Audience level");
            this.readHeaderCell("Content tags");
            this.readHeaderCell("Language");
            this.readHeaderCell("Required timeslot tags");
            this.readHeaderCell("Preferred timeslot tags");
            this.readHeaderCell("Prohibited timeslot tags");
            this.readHeaderCell("Undesired timeslot tags");
            this.readHeaderCell("Required room tags");
            this.readHeaderCell("Preferred room tags");
            this.readHeaderCell("Prohibited room tags");
            this.readHeaderCell("Undesired room tags");
            this.readHeaderCell("Pinned by user");
            this.readHeaderCell("Timeslot day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            this.readHeaderCell("Room");
            ArrayList<Talk> talkList = new ArrayList<Talk>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            Map timeslotMap = this.solution.getTimeslotList().stream().collect(Collectors.toMap(timeslot -> Pair.of((Object)timeslot.getStartDateTime(), (Object)timeslot.getEndDateTime()), Function.identity()));
            Map roomMap = this.solution.getRoomList().stream().collect(Collectors.toMap(Room::getName, Function.identity()));
            while (this.nextRow()) {
                String roomName;
                Talk talk = new Talk();
                talk.setId(id++);
                talk.setCode(this.nextCell().getStringCellValue());
                if (!VALID_CODE_PATTERN.matcher(talk.getCode()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk code (" + talk.getCode() + ") must match to the regular expression (" + VALID_CODE_PATTERN + ").");
                }
                talk.setTitle(this.nextCell().getStringCellValue());
                talk.setTalkType(this.nextCell().getStringCellValue());
                if (!this.totalTalkTypeSet.contains(talk.getTalkType())) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk type (" + talk.getTalkType() + ") does not exist in the talk types (" + this.totalTalkTypeSet + ") of the other sheet (Timeslots).");
                }
                talk.setSpeakerList(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).map(speakerName -> {
                    Speaker speaker = (Speaker)speakerMap.get(speakerName);
                    if (speaker == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a speaker (" + speakerName + ") that doesn't exist in the speaker list.");
                    }
                    return speaker;
                }).collect(Collectors.toList()));
                talk.setThemeTrackTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getThemeTrackTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s theme tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setSectorTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getSectorTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s sector tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                double audienceLevelDouble = this.nextCell().getNumericCellValue();
                if (audienceLevelDouble <= 0.0 || audienceLevelDouble != Math.floor(audienceLevelDouble)) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ")'s has an audience level (" + audienceLevelDouble + ") that isn't a strictly positive integer number.");
                }
                talk.setAudienceLevel((int)audienceLevelDouble);
                talk.setContentTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag3 : talk.getContentTagSet()) {
                    if (VALID_TAG_PATTERN.matcher(tag3).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s content tag (" + tag3 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setLanguage(this.nextCell().getStringCellValue());
                talk.setRequiredTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getRequiredTimeslotTagSet());
                talk.setPreferredTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getPreferredTimeslotTagSet());
                talk.setProhibitedTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getProhibitedTimeslotTagSet());
                talk.setUndesiredTimeslotTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getUndesiredTimeslotTagSet());
                talk.setRequiredRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getRequiredRoomTagSet());
                talk.setPreferredRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getPreferredRoomTagSet());
                talk.setProhibitedRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getProhibitedRoomTagSet());
                talk.setUndesiredRoomTagSet(Arrays.stream(this.nextCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getUndesiredRoomTagSet());
                talk.setPinnedByUser(this.nextCell().getBooleanCellValue());
                String dateString = this.nextCell().getStringCellValue();
                String startTimeString = this.nextCell().getStringCellValue();
                String endTimeString = this.nextCell().getStringCellValue();
                if (!(dateString.isEmpty() && startTimeString.isEmpty() && endTimeString.isEmpty())) {
                    LocalDateTime endDateTime;
                    LocalDateTime startDateTime;
                    try {
                        startDateTime = LocalDateTime.of(LocalDate.parse(dateString, DAY_FORMATTER), LocalTime.parse(startTimeString, TIME_FORMATTER));
                        endDateTime = LocalDateTime.of(LocalDate.parse(dateString, DAY_FORMATTER), LocalTime.parse(endTimeString, TIME_FORMATTER));
                    }
                    catch (DateTimeParseException e) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a timeslot date (" + dateString + "), startTime (" + startTimeString + ") and endTime (" + endTimeString + ") that doesn't parse as a date or time.", e);
                    }
                    Timeslot timeslot2 = (Timeslot)timeslotMap.get(Pair.of((Object)startDateTime, (Object)endDateTime));
                    if (timeslot2 == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a timeslot date (" + dateString + "), startTime (" + startTimeString + ") and endTime (" + endTimeString + ") that doesn't exist in the other sheet (Timeslots).");
                    }
                    talk.setTimeslot(timeslot2);
                }
                if (!(roomName = this.nextCell().getStringCellValue()).isEmpty()) {
                    Room room = (Room)roomMap.get(roomName);
                    if (room == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a roomName (" + roomName + ") that doesn't exist in the other sheet (Rooms).");
                    }
                    talk.setRoom(room);
                }
                talkList.add(talk);
            }
            this.solution.setTalkList(talkList);
        }

        private void verifyTimeslotTags(Set<String> timeslotTagSet) {
            for (String tag : timeslotTagSet) {
                if (this.totalTimeslotTagSet.contains(tag)) continue;
                throw new IllegalStateException(this.currentPosition() + ": The timeslot tag (" + tag + ") does not exist in the tags (" + this.totalTimeslotTagSet + ") of the other sheet (Timeslots).");
            }
        }

        private void verifyRoomTags(Set<String> roomTagSet) {
            for (String tag : roomTagSet) {
                if (this.totalRoomTagSet.contains(tag)) continue;
                throw new IllegalStateException(this.currentPosition() + ": The room tag (" + tag + ") does not exist in the tags (" + this.totalRoomTagSet + ") of the other sheet (Rooms).");
            }
        }

        private void readTimeslotDaysHeaders() {
            LocalDate previousTimeslotDay = null;
            for (Timeslot timeslot : this.solution.getTimeslotList()) {
                LocalDate timeslotDay = timeslot.getDate();
                if (timeslotDay.equals(previousTimeslotDay)) {
                    this.readHeaderCell("");
                    continue;
                }
                this.readHeaderCell(DAY_FORMATTER.format(timeslotDay));
                previousTimeslotDay = timeslotDay;
            }
        }

        private void readTimeslotHoursHeaders() {
            for (Timeslot timeslot : this.solution.getTimeslotList()) {
                this.readHeaderCell(TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + TIME_FORMATTER.format(timeslot.getEndDateTime()));
            }
        }

        protected String currentPosition() {
            return "Sheet (" + this.currentSheet.getSheetName() + ") cell (" + (this.currentRowNumber + 1) + CellReference.convertNumToColString((int)this.currentColumnNumber) + ")";
        }

        protected void nextSheet(String sheetName) {
            this.currentSheet = this.workbook.getSheet(sheetName);
            if (this.currentSheet == null) {
                throw new IllegalStateException("The workbook does not contain a sheet with name (" + sheetName + ").");
            }
            this.currentRowIterator = this.currentSheet.rowIterator();
            if (this.currentRowIterator == null) {
                throw new IllegalStateException(this.currentPosition() + ": The sheet has no rows.");
            }
            this.currentRowNumber = -1;
        }

        protected boolean nextRow() {
            return this.nextRow(true);
        }

        protected boolean nextRow(boolean skipEmptyRows) {
            ++this.currentRowNumber;
            this.currentColumnNumber = -1;
            if (!this.currentRowIterator.hasNext()) {
                this.currentRow = null;
                return false;
            }
            this.currentRow = (XSSFRow)this.currentRowIterator.next();
            while (skipEmptyRows && this.currentRow.getPhysicalNumberOfCells() == 0) {
                if (!this.currentRowIterator.hasNext()) {
                    this.currentRow = null;
                    return false;
                }
                this.currentRow = (XSSFRow)this.currentRowIterator.next();
            }
            if (this.currentRow.getRowNum() != this.currentRowNumber) {
                if (this.currentRow.getRowNum() == this.currentRowNumber + 1) {
                    ++this.currentRowNumber;
                } else {
                    throw new IllegalStateException(this.currentPosition() + ": The next row (" + this.currentRow.getRowNum() + ") has a gap of more than 1 empty line with the previous.");
                }
            }
            return true;
        }

        protected void readHeaderCell(String value) {
            XSSFCell cell;
            XSSFCell xSSFCell = cell = this.currentRow == null ? null : this.nextCell();
            if (cell == null || !cell.getStringCellValue().equals(value)) {
                throw new IllegalStateException(this.currentPosition() + ": The cell does not contain the expected value (" + value + ").");
            }
        }

        protected XSSFCell nextCell() {
            ++this.currentColumnNumber;
            XSSFCell cell = this.currentRow.getCell(this.currentColumnNumber);
            if (cell == null) {
                return this.currentRow.createCell(this.currentColumnNumber);
            }
            return cell;
        }

        protected XSSFColor extractColor(XSSFCell cell, XSSFColor ... acceptableColors) {
            XSSFCellStyle cellStyle = cell.getCellStyle();
            FillPatternType fillPattern = cellStyle.getFillPatternEnum();
            if (fillPattern == null || fillPattern == FillPatternType.NO_FILL) {
                return null;
            }
            if (fillPattern != FillPatternType.SOLID_FOREGROUND) {
                throw new IllegalStateException(this.currentPosition() + ": The fill pattern (" + fillPattern + ") should be either " + FillPatternType.NO_FILL + " or " + FillPatternType.SOLID_FOREGROUND + ".");
            }
            XSSFColor color = cellStyle.getFillForegroundColorColor();
            for (XSSFColor acceptableColor : acceptableColors) {
                if (!acceptableColor.equals((Object)color)) continue;
                return acceptableColor;
            }
            throw new IllegalStateException(this.currentPosition() + ": The fill color (" + color + ") is not one of the acceptableColors (" + Arrays.toString(acceptableColors) + ").");
        }
    }
}

