/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import java.util.function.BiFunction;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintVerification;

public final class DefaultConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_>
implements ConstraintVerifier<ConstraintProvider_, Solution_> {
    private final ConstraintProvider_ constraintProvider;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private ConstraintStreamImplType constraintStreamImplType = ConstraintStreamImplType.DROOLS;

    public DefaultConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.constraintProvider = constraintProvider;
        this.solutionDescriptor = solutionDescriptor;
    }

    protected SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        this.constraintStreamImplType = constraintStreamImplType;
        return this;
    }

    @Override
    public DefaultSingleConstraintVerification<Solution_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        Objects.requireNonNull(constraintFunction);
        ConstraintStreamScoreDirectorFactory scoreDirectorFactory = new ConstraintStreamScoreDirectorFactory(this.solutionDescriptor, constraintFactory -> new Constraint[]{(Constraint)constraintFunction.apply(this.constraintProvider, constraintFactory)}, this.constraintStreamImplType);
        return new DefaultSingleConstraintVerification(scoreDirectorFactory);
    }

    @Override
    public DefaultMultiConstraintVerification<Solution_> verifyThat() {
        ConstraintStreamScoreDirectorFactory scoreDirectorFactory = new ConstraintStreamScoreDirectorFactory(this.solutionDescriptor, this.constraintProvider, this.constraintStreamImplType);
        return new DefaultMultiConstraintVerification(scoreDirectorFactory, (ConstraintProvider)this.constraintProvider);
    }
}

