/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableDemand;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.KOptMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class KOptMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector entitySelector;
    protected final ValueSelector[] valueSelectors;
    protected final boolean randomSelection;
    protected final GenuineVariableDescriptor variableDescriptor;
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected AnchorVariableSupply anchorVariableSupply;

    public KOptMoveSelector(EntitySelector entitySelector, ValueSelector[] valueSelectors, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelectors = valueSelectors;
        this.randomSelection = randomSelection;
        if (!randomSelection) {
            throw new UnsupportedOperationException("Non randomSelection (such as original selection) is not yet supported on " + KOptMoveSelector.class.getSimpleName() + ".");
        }
        this.variableDescriptor = valueSelectors[0].getVariableDescriptor();
        if (!this.variableDescriptor.isChained()) {
            throw new IllegalStateException("The selector (" + this + ")'s valueSelector's  variableDescriptor (" + this.variableDescriptor + ") must be chained (" + this.variableDescriptor.isChained() + ").");
        }
        if (!this.variableDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(entitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a valueSelector with a entityClass (" + this.variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal or a superclass to the entitySelector's entityClass (" + entitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        for (ValueSelector valueSelector : valueSelectors) {
            if (valueSelector.getVariableDescriptor() != this.variableDescriptor) {
                throw new IllegalStateException("The selector (" + this + ") has a valueSelector with a variableDescriptor (" + valueSelector.getVariableDescriptor() + ") that differs from the first variableDescriptor (" + this.variableDescriptor + ").");
            }
            this.phaseLifecycleSupport.addEventListener(valueSelector);
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(this.variableDescriptor));
        this.anchorVariableSupply = supplyManager.demand(new AnchorVariableDemand(this.variableDescriptor));
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.anchorVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        if (!this.entitySelector.isCountable()) {
            return false;
        }
        for (ValueSelector valueSelector : this.valueSelectors) {
            if (valueSelector.isCountable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection || this.entitySelector.isNeverEnding()) {
            return true;
        }
        for (ValueSelector valueSelector : this.valueSelectors) {
            if (!valueSelector.isNeverEnding()) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            throw new UnsupportedOperationException("Non randomSelection (such as original selection) is not yet supported on " + KOptMoveSelector.class.getSimpleName() + ".");
        }
        final Iterator entityIterator = this.entitySelector.iterator();
        return new UpcomingSelectionIterator<Move>(){

            @Override
            protected Move createUpcomingSelection() {
                if (!entityIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                Object entity = entityIterator.next();
                Object[] values = new Object[KOptMoveSelector.this.valueSelectors.length];
                for (int i = 0; i < KOptMoveSelector.this.valueSelectors.length; ++i) {
                    Iterator<Object> valueIterator = KOptMoveSelector.this.valueSelectors[i].iterator(entity);
                    if (!valueIterator.hasNext()) {
                        return (Move)this.noUpcomingSelection();
                    }
                    values[i] = valueIterator.next();
                }
                return new KOptMove(KOptMoveSelector.this.variableDescriptor, KOptMoveSelector.this.inverseVariableSupply, KOptMoveSelector.this.anchorVariableSupply, entity, values);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + Arrays.toString(this.valueSelectors) + ")";
    }
}

