/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniTuple;

public final class BavetFromUniNode<A>
extends BavetAbstractUniNode<A> {
    private final Class<A> fromClass;
    private List<BavetAbstractUniNode<A>> childNodeList = new ArrayList<BavetAbstractUniNode<A>>();

    public BavetFromUniNode(BavetConstraintSession session, int nodeOrder, Class<A> fromClass) {
        super(session, nodeOrder);
        this.fromClass = fromClass;
    }

    @Override
    public void addChildNode(BavetAbstractUniNode<A> childNode) {
        this.childNodeList.add(childNode);
    }

    public int hashCode() {
        return this.fromClass.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFromUniNode) {
            BavetFromUniNode other = (BavetFromUniNode)o;
            return this.fromClass.equals(other.fromClass);
        }
        return false;
    }

    public BavetFromUniTuple<A> createTuple(A a) {
        return new BavetFromUniTuple<A>(this, a, this.childNodeList.size());
    }

    @Override
    public BavetAbstractUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        throw new IllegalStateException("The fromUniNode (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    public void refresh(BavetFromUniTuple<A> tuple) {
        List<BavetAbstractUniTuple<A>> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractUniTuple<A> bavetAbstractUniTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractUniTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            for (BavetAbstractUniNode bavetAbstractUniNode : this.childNodeList) {
                BavetAbstractUniTuple<A> childTuple = bavetAbstractUniNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
        tuple.refreshed();
    }

    public String toString() {
        return "From(" + this.fromClass.getSimpleName() + ") with " + this.childNodeList.size() + " children";
    }
}

