/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.kie.api.runtime.process.ProcessInstance;

public class RuleFlowVariableLogEvent
extends RuleFlowLogEvent {
    private String variableId;
    private String variableInstanceId;
    private String objectToString;

    public RuleFlowVariableLogEvent(int type, String variableId, String variableInstanceId, ProcessInstance processInstance, String objectToString) {
        this(type, variableId, variableInstanceId, processInstance.getProcessId(), processInstance.getProcessName(), processInstance.getId(), objectToString);
    }

    public RuleFlowVariableLogEvent(int type, String variableId, String variableInstanceId, String processId, String processName, Object processInstanceId, String objectToString) {
        super(type, processId, processName, processInstanceId);
        this.variableId = variableId;
        this.variableInstanceId = variableInstanceId;
        this.objectToString = objectToString;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.variableId = (String)in.readObject();
        this.variableInstanceId = (String)in.readObject();
        this.objectToString = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.variableId);
        out.writeObject(this.variableInstanceId);
        out.writeObject(this.objectToString);
    }

    public String getVariableId() {
        return this.variableId;
    }

    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public String getObjectToString() {
        return this.objectToString;
    }

    @Override
    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 32: {
                msg = "BEFORE RULEFLOW VARIABLE CHANGED";
                break;
            }
            case 33: {
                msg = "AFTER RULEFLOW VARIABLE CHANGED";
                break;
            }
            default: {
                return super.toString();
            }
        }
        return msg + " " + this.variableId + "=" + this.objectToString + " process:" + this.getProcessName() + "[id=" + this.getProcessId() + "]";
    }
}

