/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class WebsiteResourceUtils {
    private static final String RESOURCE_NAMESPACE = "/org/optaplanner/benchmark/impl/report/";

    public static void copyResourcesTo(File benchmarkReportDirectory) {
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/css/bootstrap-responsive.css");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/css/bootstrap.css");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/css/prettify.css");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/img/glyphicons-halflings-white.png");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/img/glyphicons-halflings.png");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/js/bootstrap.js");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/js/jquery.js");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "twitterbootstrap/js/prettify.js");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "website/css/benchmarkReport.css");
        WebsiteResourceUtils.copyResource(benchmarkReportDirectory, "website/img/optaPlannerLogo.png");
    }

    private static void copyResource(File benchmarkReportDirectory, String websiteResource) {
        File outputFile = new File(benchmarkReportDirectory, websiteResource);
        outputFile.getParentFile().mkdirs();
        try (InputStream in = WebsiteResourceUtils.class.getResourceAsStream(RESOURCE_NAMESPACE + websiteResource);
             FileOutputStream out = new FileOutputStream(outputFile);){
            if (in == null) {
                throw new IllegalStateException("The websiteResource (" + websiteResource + ") does not exist.");
            }
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not copy websiteResource (" + websiteResource + ") to outputFile (" + outputFile + ").", e);
        }
    }

    private WebsiteResourceUtils() {
    }
}

