/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.ReturnValueExpression;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.security.KiePolicyHelper;

public class JavaAccumulatorFunctionExecutor
implements Accumulator,
Externalizable,
Wireable {
    private static final long serialVersionUID = 510L;
    private ReturnValueExpression expression;
    private AccumulateFunction function;

    public JavaAccumulatorFunctionExecutor() {
    }

    public JavaAccumulatorFunctionExecutor(AccumulateFunction function) {
        this.function = function;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (ReturnValueExpression)in.readObject();
        this.function = (AccumulateFunction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (ReturnValueExpression.isCompiledInvoker(this.expression)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.function);
    }

    @Override
    public Object createContext() {
        return this.function.createContext();
    }

    @Override
    public Object init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) {
        return this.function.initContext((Serializable)context);
    }

    @Override
    public Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        try {
            Object value = this.expression.evaluate(handle, leftTuple, declarations, innerDeclarations, workingMemory, workingMemoryContext).getValue();
            return this.function.accumulateValue((Serializable)context, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        return this.function.tryReverse((Serializable)context, value);
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) {
        try {
            return this.function.getResult((Serializable)context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportsReverse() {
        return this.function.supportsReverse();
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    @Override
    public void wire(Object object) {
        this.setExpression(KiePolicyHelper.isPolicyEnabled() ? new ReturnValueExpression.SafeReturnValueExpression((ReturnValueExpression)object) : (ReturnValueExpression)object);
    }

    public void setExpression(ReturnValueExpression expression) {
        this.expression = expression;
    }

    @Override
    public Object createWorkingMemoryContext() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaAccumulatorFunctionExecutor that = (JavaAccumulatorFunctionExecutor)o;
        return this.expression.equals(that.expression) && this.function.equals(that.function);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }
}

