/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.util.LinkedList;
import java.util.List;
import org.drools.template.model.AttributedDRLElement;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLJavaEmitter;
import org.drools.template.model.DRLOutput;

public class Rule
extends AttributedDRLElement
implements DRLJavaEmitter {
    public static final int MAX_ROWS = 65535;
    private String _name;
    private String _description;
    private List<String> _metadata;
    private List<Condition> _lhs;
    private List<Consequence> _rhs;
    private int _spreadsheetRow;

    public Rule(String name, Integer salience, int spreadsheetRow) {
        super(salience);
        this._name = this.asStringLiteral(name);
        this._description = null;
        this._metadata = new LinkedList<String>();
        this._lhs = new LinkedList<Condition>();
        this._rhs = new LinkedList<Consequence>();
        this._spreadsheetRow = spreadsheetRow;
    }

    public void addMetadata(String meta) {
        this._metadata.add(meta);
    }

    public void addCondition(Condition con) {
        this._lhs.add(con);
    }

    public void addConsequence(Consequence con) {
        this._rhs.add(con);
    }

    @Override
    public void renderDRL(DRLOutput out) {
        if (this.isCommented()) {
            out.writeLine("//" + this.getComment());
        }
        out.writeLine("rule " + this._name);
        if (this._description != null) {
            out.writeLine("/* " + this._description + " */");
        }
        for (String ms : this._metadata) {
            out.writeLine("\t@" + ms);
        }
        super.renderDRL(out);
        out.writeLine("\twhen");
        this.renderDRL(this._lhs, out);
        out.writeLine("\tthen");
        this.renderDRL(this._rhs, out);
        out.writeLine("end\n");
    }

    private void renderDRL(List<? extends DRLJavaEmitter> list, DRLOutput out) {
        for (DRLJavaEmitter dRLJavaEmitter : list) {
            dRLJavaEmitter.renderDRL(out);
        }
    }

    public List<String> getMetadata() {
        return this._metadata;
    }

    public List<Condition> getConditions() {
        return this._lhs;
    }

    public List<Consequence> getConsequences() {
        return this._rhs;
    }

    public void setName(String value) {
        this._name = this.asStringLiteral(value);
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public void appendDescription(String value) {
        this._description = this._description + value;
    }

    public int getSpreadsheetRowNumber() {
        return this._spreadsheetRow;
    }
}

