/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.rocktour.domain.RockBus;
import org.optaplanner.examples.rocktour.domain.RockLocation;
import org.optaplanner.examples.rocktour.domain.RockShow;
import org.optaplanner.examples.rocktour.domain.RockTourParametrization;
import org.optaplanner.examples.rocktour.domain.RockTourSolution;

public class RockTourXlsxFileIO
extends AbstractXlsxSolutionFileIO<RockTourSolution> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RockTourSolution read(File inputSolutionFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputSolutionFile));){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            RockTourSolution rockTourSolution = new RockTourXslxReader(workbook).read();
            return rockTourSolution;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(RockTourSolution solution, File outputSolutionFile) {
        try (FileOutputStream out = new FileOutputStream(outputSolutionFile);){
            Workbook workbook = new RockTourXlsxWriter(solution).write();
            workbook.write((OutputStream)out);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed writing outputSolutionFile (" + outputSolutionFile + ") for solution (" + solution + ").", e);
        }
    }

    private static class RockTourXlsxWriter
    extends AbstractXlsxSolutionFileIO.AbstractXlsxWriter<RockTourSolution> {
        public RockTourXlsxWriter(RockTourSolution solution) {
            super(solution, "org/optaplanner/examples/rocktour/solver/rockTourSolverConfig.xml");
        }

        @Override
        public Workbook write() {
            this.writeSetup();
            this.writeConfiguration();
            this.writeBus();
            this.writeShowList();
            this.writeDrivingTime();
            this.writeStopsView();
            return this.workbook;
        }

        private void writeConfiguration() {
            this.nextSheet("Configuration", 1, 8, false);
            this.nextRow();
            this.nextHeaderCell("Tour name");
            this.nextCell().setCellValue(((RockTourSolution)this.solution).getTourName());
            RockTourParametrization parametrization = ((RockTourSolution)this.solution).getParametrization();
            this.writeLongConstraintLine("Early late break driving seconds budget", parametrization::getEarlyLateBreakDrivingSecondsBudget, "Maximum driving time in seconds between 2 shows on the same day.");
            this.writeLongConstraintLine("Night driving seconds budget", parametrization::getNightDrivingSecondsBudget, "Maximum driving time in seconds per night between 2 shows.");
            this.writeLongConstraintLine("HOS week driving seconds budget", parametrization::getHosWeekDrivingSecondsBudget, "Maximum driving time in seconds since last weekend rest.");
            this.writeIntConstraintLine("HOS week consecutive driving days budget", parametrization::getHosWeekConsecutiveDrivingDaysBudget, "Maximum driving days since last weekend rest.");
            this.writeIntConstraintLine("HOS week rest days", parametrization::getHosWeekRestDays, "Minimum weekend rest in days (actually in full night sleeps: 2 days guarantees only 32 hours).");
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Constraint");
            this.nextHeaderCell("Weight");
            this.nextHeaderCell("Description");
            this.writeLongConstraintLine("Minimize missed shows", parametrization::getMissedShowPenalty, "Set this to 1 to prioritize visiting all shows (over the other constraints).");
            this.writeLongConstraintLine("Maximize revenue opportunity", parametrization::getRevenueOpportunity, "Reward per revenue opportunity.");
            this.writeLongConstraintLine("Minimize driving time cost", parametrization::getDrivingTimeCostPerSecond, "Driving time cost per second.");
            this.writeLongConstraintLine("Visit sooner than later", parametrization::getDelayCostPerDay, "Cost per day for each day that a visit is later in the schedule.");
            this.autoSizeColumnsWithHeader();
        }

        private void writeBus() {
            this.nextSheet("Bus", 1, 0, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("City name");
            this.nextHeaderCell("Latitude");
            this.nextHeaderCell("Longitude");
            this.nextHeaderCell("Date");
            RockBus bus = ((RockTourSolution)this.solution).getBus();
            this.nextRow();
            this.nextHeaderCell("Bus start");
            this.nextCell().setCellValue(bus.getStartLocation().getCityName());
            this.nextCell().setCellValue(bus.getStartLocation().getLatitude());
            this.nextCell().setCellValue(bus.getStartLocation().getLongitude());
            this.nextCell().setCellValue(DAY_FORMATTER.format(bus.getStartDate()));
            this.nextRow();
            this.nextHeaderCell("Bus end");
            this.nextCell().setCellValue(bus.getEndLocation().getCityName());
            this.nextCell().setCellValue(bus.getEndLocation().getLatitude());
            this.nextCell().setCellValue(bus.getEndLocation().getLongitude());
            this.nextCell().setCellValue(DAY_FORMATTER.format(bus.getEndDate()));
            this.autoSizeColumnsWithHeader();
        }

        private void writeShowList() {
            this.nextSheet("Shows", 1, 3, false);
            LocalDate startDate = ((RockTourSolution)this.solution).getBus().getStartDate();
            LocalDate endDate = ((RockTourSolution)this.solution).getBus().getEndDate();
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("Availability");
            this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber + (int)ChronoUnit.DAYS.between(startDate, endDate) - 1));
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            LocalDate date = startDate;
            while (date.compareTo(endDate) < 0) {
                if (date.equals(startDate) || date.getDayOfMonth() == 1) {
                    this.nextHeaderCell(MONTH_FORMATTER.format(date));
                    LocalDate startNextMonthDate = date.with(TemporalAdjusters.firstDayOfNextMonth());
                    if (endDate.compareTo(startNextMonthDate) < 0) {
                        startNextMonthDate = endDate;
                    }
                    this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber + (int)ChronoUnit.DAYS.between(date, startNextMonthDate) - 1));
                } else {
                    this.nextCell();
                }
                date = date.plusDays(1L);
            }
            this.nextRow();
            this.nextHeaderCell("Venue name");
            this.nextHeaderCell("City name");
            this.nextHeaderCell("Latitude");
            this.nextHeaderCell("Longitude");
            this.nextHeaderCell("Duration (in days)");
            this.nextHeaderCell("Revenue opportunity");
            this.nextHeaderCell("Required");
            date = startDate;
            while (date.compareTo(endDate) < 0) {
                this.nextHeaderCell(Integer.toString(date.getDayOfMonth()));
                date = date.plusDays(1L);
            }
            for (RockShow show : ((RockTourSolution)this.solution).getShowList()) {
                this.nextRow();
                this.nextCell().setCellValue(show.getVenueName());
                this.nextCell().setCellValue(show.getLocation().getCityName());
                this.nextCell().setCellValue(show.getLocation().getLatitude());
                this.nextCell().setCellValue(show.getLocation().getLongitude());
                this.nextCell().setCellValue((double)show.getDurationInHalfDay() * 0.5);
                this.nextCell().setCellValue((double)show.getRevenueOpportunity());
                this.nextCell().setCellValue(show.isRequired());
                LocalDate date2 = startDate;
                while (date2.compareTo(endDate) < 0) {
                    if (show.getAvailableDateSet().contains(date2)) {
                        this.nextCell();
                    } else {
                        this.nextCell(this.unavailableStyle);
                    }
                    date2 = date2.plusDays(1L);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeDrivingTime() {
            this.nextSheet("Driving time", 2, 3, false);
            this.nextRow();
            this.nextHeaderCell("Driving time in seconds. Delete this sheet to generate it from air distances.");
            this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber + 10));
            Map latLongToLocationMap = Stream.concat(Stream.of(((RockTourSolution)this.solution).getBus().getStartLocation(), ((RockTourSolution)this.solution).getBus().getEndLocation()), ((RockTourSolution)this.solution).getShowList().stream().map(RockShow::getLocation)).distinct().sorted(Comparator.comparing(RockLocation::getLatitude).thenComparing(RockLocation::getLongitude).thenComparing(RockLocation::getCityName)).collect(Collectors.groupingBy(location -> Pair.of((Object)location.getLatitude(), (Object)location.getLongitude()), LinkedHashMap::new, Collectors.toList()));
            this.nextRow();
            this.nextHeaderCell("Latitude");
            this.nextHeaderCell("");
            for (Pair latLong : latLongToLocationMap.keySet()) {
                this.nextHeaderCell((Double)latLong.getLeft());
            }
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("Longitude");
            for (Pair latLong : latLongToLocationMap.keySet()) {
                this.nextHeaderCell((Double)latLong.getRight());
            }
            latLongToLocationMap.forEach((fromLatLong, fromLocationList) -> {
                this.nextRow();
                this.nextHeaderCell((Double)fromLatLong.getLeft());
                this.nextHeaderCell((Double)fromLatLong.getRight());
                latLongToLocationMap.forEach((toLatLong, toLocationList) -> {
                    long drivingTime = ((RockLocation)fromLocationList.get(0)).getDrivingTimeTo((RockLocation)toLocationList.get(0));
                    for (RockLocation fromLocation : fromLocationList) {
                        for (RockLocation toLocation : toLocationList) {
                            if (fromLocation.getDrivingTimeTo(toLocation) == drivingTime) continue;
                            throw new IllegalStateException("The driving time (" + drivingTime + ") from (" + fromLocationList.get(0) + ") to (" + toLocationList.get(0) + ") is not the driving time (" + fromLocation.getDrivingTimeTo(toLocation) + ") from (" + fromLocation + ") to (" + toLocation + ").");
                        }
                    }
                    this.nextCell().setCellValue((double)drivingTime);
                });
            });
            this.autoSizeColumnsWithHeader();
        }

        private void writeStopsView() {
            this.nextSheet("Stops", 2, 1, true);
            this.nextRow();
            this.nextHeaderCell("Date");
            this.nextHeaderCell("Venue name");
            this.nextHeaderCell("City name");
            this.nextHeaderCell("Driving time");
            this.nextHeaderCell("Driving time per week");
            this.nextHeaderCell("Latitude");
            this.nextHeaderCell("Longitude");
            this.nextHeaderCell("Duration (in days)");
            this.nextHeaderCell("Revenue opportunity");
            this.nextHeaderCell("Required");
            this.nextHeaderCell("Available dates size");
            LocalDate startDate = ((RockTourSolution)this.solution).getBus().getStartDate();
            LocalDate endDate = ((RockTourSolution)this.solution).getBus().getEndDate();
            Map<LocalDate, List<RockShow>> dateToShowListMap = ((RockTourSolution)this.solution).getShowList().stream().filter(show -> show.getDate() != null).collect(Collectors.groupingBy(RockShow::getDate));
            long drivingTimeWeekTotal = 0L;
            LocalDate date = startDate;
            while (date.compareTo(endDate) < 0) {
                List showList = dateToShowListMap.computeIfAbsent(date, k -> Collections.emptyList());
                showList.sort(Comparator.comparing(RockShow::getTimeOfDay).thenComparing(RockShow::getVenueName));
                this.nextRow();
                if (date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                    this.nextCell(this.unavailableStyle).setCellValue(DAY_FORMATTER.format(date));
                } else {
                    this.nextHeaderCell(DAY_FORMATTER.format(date));
                }
                if (!showList.isEmpty()) {
                    boolean first = true;
                    for (RockShow show2 : showList) {
                        if (!first) {
                            this.nextRow();
                            this.nextCell();
                        }
                        this.nextCell().setCellValue(show2.getVenueName());
                        this.nextCell().setCellValue(show2.getLocation().getCityName());
                        long drivingTime = show2.getDrivingTimeFromPreviousStandstill();
                        drivingTimeWeekTotal += drivingTime;
                        this.nextCell().setCellValue(RockTourXlsxWriter.toHoursAndMinutes(drivingTime));
                        if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                            this.nextCell().setCellValue(RockTourXlsxWriter.toHoursAndMinutes(drivingTimeWeekTotal));
                            drivingTimeWeekTotal = 0L;
                        } else {
                            this.nextCell();
                        }
                        this.nextCell().setCellValue(show2.getLocation().getLatitude());
                        this.nextCell().setCellValue(show2.getLocation().getLongitude());
                        this.nextCell().setCellValue((double)show2.getDurationInHalfDay() * 0.5);
                        this.nextCell().setCellValue((double)show2.getRevenueOpportunity());
                        this.nextCell().setCellValue(show2.isRequired());
                        this.nextCell().setCellValue((double)show2.getAvailableDateSet().size());
                        first = false;
                    }
                } else {
                    this.nextCell();
                    this.nextCell();
                    this.nextCell();
                    if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                        this.nextCell().setCellValue(RockTourXlsxWriter.toHoursAndMinutes(drivingTimeWeekTotal));
                        drivingTimeWeekTotal = 0L;
                    }
                }
                date = date.plusDays(1L);
            }
            this.nextRow();
            this.nextRow();
            long revenueOpportunityLoss = 0L;
            for (RockShow show3 : ((RockTourSolution)this.solution).getShowList().stream().filter(show -> show.getDate() == null).sorted(Comparator.comparing(RockShow::getVenueName)).collect(Collectors.toList())) {
                this.nextRow();
                this.nextHeaderCell("Unassigned");
                this.nextCell().setCellValue(show3.getVenueName());
                this.nextCell().setCellValue(show3.getLocation().getCityName());
                this.nextCell().setCellValue("0");
                this.nextCell().setCellValue(show3.getLocation().getLatitude());
                this.nextCell().setCellValue(show3.getLocation().getLongitude());
                this.nextCell().setCellValue((double)show3.getDurationInHalfDay() * 0.5);
                this.nextCell().setCellValue((double)show3.getRevenueOpportunity());
                revenueOpportunityLoss += (long)show3.getRevenueOpportunity();
                this.nextCell().setCellValue(show3.isRequired());
                this.nextCell().setCellValue((double)show3.getAvailableDateSet().size());
            }
            this.nextRow();
            this.nextHeaderCell("Total revenue opportunity loss");
            this.nextCell();
            this.nextCell();
            this.nextCell();
            this.nextCell();
            this.nextCell();
            this.nextCell();
            this.nextCell().setCellValue((double)revenueOpportunityLoss);
            this.autoSizeColumnsWithHeader();
        }

        private static String toHoursAndMinutes(long drivingTimeWeekTotal) {
            return drivingTimeWeekTotal / 3600L + " hours " + drivingTimeWeekTotal % 3600L / 60L + " minutes";
        }
    }

    private static class RockTourXslxReader
    extends AbstractXlsxSolutionFileIO.AbstractXslxReader<RockTourSolution> {
        public RockTourXslxReader(XSSFWorkbook workbook) {
            super(workbook);
        }

        @Override
        public RockTourSolution read() {
            this.solution = new RockTourSolution();
            this.readConfiguration();
            this.readBus();
            this.readShowList();
            this.readDrivingTime();
            return (RockTourSolution)this.solution;
        }

        private void readConfiguration() {
            this.nextSheet("Configuration");
            this.nextRow();
            this.readHeaderCell("Tour name");
            ((RockTourSolution)this.solution).setTourName(this.nextStringCell().getStringCellValue());
            if (!VALID_NAME_PATTERN.matcher(((RockTourSolution)this.solution).getTourName()).matches()) {
                throw new IllegalStateException(this.currentPosition() + ": The tour name (" + ((RockTourSolution)this.solution).getTourName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
            }
            RockTourParametrization parametrization = new RockTourParametrization();
            this.readLongConstraintLine("Early late break driving seconds budget", parametrization::setEarlyLateBreakDrivingSecondsBudget, "Maximum driving time in seconds between 2 shows on the same day.");
            this.readLongConstraintLine("Night driving seconds budget", parametrization::setNightDrivingSecondsBudget, "Maximum driving time in seconds per night between 2 shows.");
            this.readLongConstraintLine("HOS week driving seconds budget", parametrization::setHosWeekDrivingSecondsBudget, "Maximum driving time in seconds since last weekend rest.");
            this.readIntConstraintLine("HOS week consecutive driving days budget", parametrization::setHosWeekConsecutiveDrivingDaysBudget, "Maximum driving days since last weekend rest.");
            this.readIntConstraintLine("HOS week rest days", parametrization::setHosWeekRestDays, "Minimum weekend rest in days (actually in full night sleeps: 2 days guarantees only 32 hours).");
            this.nextRow(true);
            this.readHeaderCell("Constraint");
            this.readHeaderCell("Weight");
            this.readHeaderCell("Description");
            parametrization.setId(0L);
            this.readLongConstraintLine("Minimize missed shows", parametrization::setMissedShowPenalty, "Set this to 1 to prioritize visiting all shows (over the other constraints).");
            this.readLongConstraintLine("Maximize revenue opportunity", parametrization::setRevenueOpportunity, "Reward per revenue opportunity.");
            this.readLongConstraintLine("Minimize driving time cost", parametrization::setDrivingTimeCostPerSecond, "Driving time cost per second.");
            this.readLongConstraintLine("Visit sooner than later", parametrization::setDelayCostPerDay, "Cost per day for each day that a visit is later in the schedule.");
            ((RockTourSolution)this.solution).setParametrization(parametrization);
        }

        private void readBus() {
            this.nextSheet("Bus");
            RockBus bus = new RockBus();
            bus.setId(0L);
            this.nextRow();
            this.readHeaderCell("");
            this.readHeaderCell("City name");
            this.readHeaderCell("Latitude");
            this.readHeaderCell("Longitude");
            this.readHeaderCell("Date");
            this.nextRow();
            this.readHeaderCell("Bus start");
            String startCityName = this.nextStringCell().getStringCellValue();
            double startLatitude = this.nextNumericCell().getNumericCellValue();
            double startLongitude = this.nextNumericCell().getNumericCellValue();
            bus.setStartLocation(new RockLocation(startCityName, startLatitude, startLongitude));
            bus.setStartDate(LocalDate.parse(this.nextStringCell().getStringCellValue(), DAY_FORMATTER));
            this.nextRow();
            this.readHeaderCell("Bus end");
            String endCityName = this.nextStringCell().getStringCellValue();
            double endLatitude = this.nextNumericCell().getNumericCellValue();
            double endLongitude = this.nextNumericCell().getNumericCellValue();
            bus.setEndLocation(new RockLocation(endCityName, endLatitude, endLongitude));
            bus.setEndDate(LocalDate.parse(this.nextStringCell().getStringCellValue(), DAY_FORMATTER));
            ((RockTourSolution)this.solution).setBus(bus);
        }

        private void readShowList() {
            this.nextSheet("Shows");
            LocalDate startDate = ((RockTourSolution)this.solution).getBus().getStartDate();
            LocalDate endDate = ((RockTourSolution)this.solution).getBus().getEndDate();
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("Availability");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            LocalDate date = startDate;
            while (date.compareTo(endDate) < 0) {
                if (date.equals(startDate) || date.getDayOfMonth() == 1) {
                    this.readHeaderCell(MONTH_FORMATTER.format(date));
                } else {
                    this.readHeaderCell("");
                }
                date = date.plusDays(1L);
            }
            this.nextRow(false);
            this.readHeaderCell("Venue name");
            this.readHeaderCell("City name");
            this.readHeaderCell("Latitude");
            this.readHeaderCell("Longitude");
            this.readHeaderCell("Duration (in days)");
            this.readHeaderCell("Revenue opportunity");
            this.readHeaderCell("Required");
            date = startDate;
            while (date.compareTo(endDate) < 0) {
                this.readHeaderCell(Integer.toString(date.getDayOfMonth()));
                date = date.plusDays(1L);
            }
            ArrayList<RockShow> showList = new ArrayList<RockShow>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                RockShow show = new RockShow();
                show.setId(id);
                show.setVenueName(this.nextStringCell().getStringCellValue());
                String cityName = this.nextStringCell().getStringCellValue();
                double latitude = this.nextNumericCell().getNumericCellValue();
                double longitude = this.nextNumericCell().getNumericCellValue();
                show.setLocation(new RockLocation(cityName, latitude, longitude));
                double duration = this.nextNumericCell().getNumericCellValue();
                int durationInHalfDay = (int)(duration * 2.0);
                if ((double)durationInHalfDay != duration * 2.0) {
                    throw new IllegalStateException(this.currentPosition() + ": The duration (" + duration + ") should be a multiple of 0.5.");
                }
                if (durationInHalfDay < 1) {
                    throw new IllegalStateException(this.currentPosition() + ": The duration (" + duration + ") should be at least 0.5.");
                }
                show.setDurationInHalfDay(durationInHalfDay);
                double revenueOpportunityDouble = this.nextNumericCell().getNumericCellValue();
                if (revenueOpportunityDouble != (double)((int)revenueOpportunityDouble)) {
                    throw new IllegalStateException(this.currentPosition() + ": The show (" + show.getVenueName() + ")'s revenue opportunity (" + revenueOpportunityDouble + ") must be an integer number.");
                }
                show.setRevenueOpportunity((int)revenueOpportunityDouble);
                show.setRequired(this.nextBooleanCell().getBooleanCellValue());
                TreeSet<LocalDate> availableDateSet = new TreeSet<LocalDate>();
                LocalDate date2 = startDate;
                while (date2.compareTo(endDate) < 0) {
                    XSSFCell cell = this.nextStringCell();
                    if (!Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        availableDateSet.add(date2);
                    }
                    if (!cell.getStringCellValue().isEmpty()) {
                        throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty.");
                    }
                    date2 = date2.plusDays(1L);
                }
                if (availableDateSet.isEmpty()) {
                    throw new IllegalStateException(this.currentPosition() + ": The show (" + show.getVenueName() + ")'s has no available date: all dates are unavailable.");
                }
                show.setAvailableDateSet(availableDateSet);
                ++id;
                showList.add(show);
            }
            ((RockTourSolution)this.solution).setShowList(showList);
        }

        private void readDrivingTime() {
            Map latLongToLocationMap = Stream.concat(Stream.of(((RockTourSolution)this.solution).getBus().getStartLocation(), ((RockTourSolution)this.solution).getBus().getEndLocation()), ((RockTourSolution)this.solution).getShowList().stream().map(RockShow::getLocation)).distinct().sorted(Comparator.comparing(RockLocation::getLatitude).thenComparing(RockLocation::getLongitude).thenComparing(RockLocation::getCityName)).collect(Collectors.groupingBy(location -> Pair.of((Object)location.getLatitude(), (Object)location.getLongitude()), LinkedHashMap::new, Collectors.toList()));
            if (!this.hasSheet("Driving time")) {
                latLongToLocationMap.forEach((fromLatLong, fromLocationList) -> {
                    for (RockLocation fromLocation : fromLocationList) {
                        fromLocation.setDrivingSecondsMap(new LinkedHashMap<RockLocation, Long>(fromLocationList.size()));
                    }
                    latLongToLocationMap.forEach((toLatLong, toLocationList) -> {
                        long drivingTime = 0L;
                        for (RockLocation fromLocation : fromLocationList) {
                            for (RockLocation toLocation : toLocationList) {
                                drivingTime = fromLocation.getAirDistanceTo(toLocation);
                                fromLocation.getDrivingSecondsMap().put(toLocation, drivingTime);
                            }
                        }
                    });
                });
                return;
            }
            this.nextSheet("Driving time");
            this.nextRow();
            this.readHeaderCell("Driving time in seconds. Delete this sheet to generate it from air distances.");
            this.nextRow();
            this.readHeaderCell("Latitude");
            this.readHeaderCell("");
            for (Pair latLong : latLongToLocationMap.keySet()) {
                this.readHeaderCell((Double)latLong.getLeft());
            }
            this.nextRow();
            this.readHeaderCell("");
            this.readHeaderCell("Longitude");
            for (Pair latLong : latLongToLocationMap.keySet()) {
                this.readHeaderCell((Double)latLong.getRight());
            }
            latLongToLocationMap.forEach((fromLatLong, fromLocationList) -> {
                this.nextRow();
                this.readHeaderCell((Double)fromLatLong.getLeft());
                this.readHeaderCell((Double)fromLatLong.getRight());
                for (RockLocation fromLocation : fromLocationList) {
                    fromLocation.setDrivingSecondsMap(new LinkedHashMap<RockLocation, Long>(fromLocationList.size()));
                }
                latLongToLocationMap.forEach((toLatLong, toLocationList) -> {
                    long drivingTime;
                    double drivingTimeDouble = this.nextNumericCell().getNumericCellValue();
                    if (drivingTimeDouble != (double)(drivingTime = (long)drivingTimeDouble)) {
                        throw new IllegalStateException(this.currentPosition() + ": The driving time (" + drivingTimeDouble + ") should be an integer number.");
                    }
                    for (RockLocation fromLocation : fromLocationList) {
                        for (RockLocation toLocation : toLocationList) {
                            fromLocation.getDrivingSecondsMap().put(toLocation, drivingTime);
                        }
                    }
                });
            });
        }
    }
}

