/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.core.xml.Handler;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensibleXmlParser
extends DefaultHandler {
    protected static final transient Logger logger = LoggerFactory.getLogger(ExtensibleXmlParser.class);
    public static final String ENTITY_RESOLVER_PROPERTY_NAME = "org.drools.core.io.EntityResolver";
    public static final String RULES_NAMESPACE_URI = "http://drools.org/rules";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private SAXParser parser;
    private boolean isValidating = true;
    private int timeout = 0;
    private Locator locator;
    private LinkedList configurationStack;
    private StringBuilder characters;
    private SemanticModules modules;
    private boolean lastWasEndElement;
    private LinkedList parents;
    private Object peer;
    private Object current;
    private Object data;
    private final MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");
    private final Map namespaces = new HashMap();
    private EntityResolver entityResolver;
    private Document document;
    private DocumentFragment docFragment;
    private ClassLoader classLoader;
    private Map metaData = new HashMap();
    private Attributes attrs;
    private int direction = 0;

    public ExtensibleXmlParser() {
        this.configurationStack = new LinkedList();
        this.parents = new LinkedList();
        this.initEntityResolver();
    }

    public void setSemanticModules(SemanticModules modules) {
        this.modules = modules;
    }

    public ExtensibleXmlParser(SAXParser parser) {
        this();
        this.parser = parser;
    }

    public Object read(Reader reader) throws SAXException, IOException {
        return this.read(new InputSource(reader));
    }

    public Object read(InputStream inputStream) throws SAXException, IOException {
        return this.read(new InputSource(inputStream));
    }

    public Object read(InputSource in) throws SAXException, IOException {
        if (this.docFragment == null) {
            DocumentBuilderFactory f;
            try {
                f = DocumentBuilderFactory.newInstance();
            }
            catch (FactoryConfigurationError e) {
                try {
                    f = (DocumentBuilderFactory)Class.forName("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl").newInstance();
                }
                catch (Exception e1) {
                    throw new RuntimeException("Unable to create new DOM Document", e1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new DOM Document", e);
            }
            try {
                f.setFeature("http://xml.org/sax/features/external-general-entities", false);
                f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException e) {
                logger.warn("Unable to set parser features due to {}", (Object)e.getMessage());
            }
            try {
                this.document = f.newDocumentBuilder().newDocument();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new DOM Document", e);
            }
            this.docFragment = this.document.createDocumentFragment();
        }
        SAXParser localParser = null;
        if (this.parser == null) {
            SAXParserFactory factory = null;
            try {
                factory = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError e) {
                try {
                    factory = (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
                }
                catch (Exception e1) {
                    throw new RuntimeException("Unable to create new DOM Document", e1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new DOM Document", e);
            }
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException e) {
                logger.warn("Unable to set parser features due to {}", (Object)e.getMessage());
            }
            if (System.getProperty("drools.schema.validating") != null) {
                this.isValidating = Boolean.getBoolean("drools.schema.validating");
            }
            if (this.isValidating) {
                factory.setValidating(true);
                try {
                    localParser = factory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e.getMessage());
                }
                try {
                    localParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (SAXNotRecognizedException e) {
                    boolean hideWarnings = Boolean.getBoolean("drools.schema.hidewarnings");
                    if (!hideWarnings) {
                        logger.warn("Your SAX parser is not JAXP 1.2 compliant - turning off validation.");
                    }
                    localParser = null;
                }
            }
            if (localParser == null) {
                try {
                    this.isValidating = false;
                    factory.setValidating(this.isValidating);
                    localParser = factory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        } else {
            localParser = this.parser;
        }
        if (!localParser.isNamespaceAware()) {
            throw new RuntimeException("parser must be namespace-aware");
        }
        localParser.parse(in, (DefaultHandler)this);
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Map getMetaData() {
        return this.metaData;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void startDocument() {
        this.isValidating = true;
        this.current = null;
        this.peer = null;
        this.lastWasEndElement = false;
        this.parents.clear();
        this.characters = null;
        this.configurationStack.clear();
        this.namespaces.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        this.attrs = attrs;
        if (this.direction == 1) {
            this.peer = null;
        } else {
            this.direction = 1;
        }
        Handler handler = this.getHandler(uri, localName);
        if (handler == null) {
            this.startElementBuilder(localName, attrs);
            return;
        }
        this.validate(uri, localName, handler);
        Object node = handler.start(uri, localName, attrs, this);
        this.parents.add(node);
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        this.direction = -1;
        Handler handler = this.getHandler(uri, localName);
        if (handler == null) {
            if (this.configurationStack.size() >= 1) {
                this.endElementBuilder();
            }
            return;
        }
        this.current = this.removeParent();
        this.peer = handler.end(uri, localName, this);
    }

    private void validate(String uri, String localName, Handler handler) throws SAXParseException {
        boolean validParent = false;
        boolean validPeer = false;
        boolean invalidNesting = false;
        Set<Class<?>> validParents = handler.getValidParents();
        Set<Class<?>> validPeers = handler.getValidPeers();
        boolean allowNesting = handler.allowNesting();
        if (validParents == null || validPeers == null) {
            return;
        }
        Class<?> nodeClass = this.getHandler(uri, localName).generateNodeFor();
        if (nodeClass != null && !nodeClass.isInstance(this.getParent())) {
            Iterator<Class<?>> it = validParents.iterator();
            while (!validParent && it.hasNext()) {
                Class<?> allowedParent = it.next();
                if (this.getParent() == null && allowedParent == null) {
                    validParent = true;
                    continue;
                }
                if (allowedParent == null || !allowedParent.isInstance(this.getParent())) continue;
                validParent = true;
            }
            if (!validParent) {
                throw new SAXParseException("<" + localName + "> has an invalid parent element [" + this.getParent() + "]", this.getLocator());
            }
        }
        Object peer = this.peer;
        Iterator<Class<Object>> it = validPeers.iterator();
        while (!validPeer && it.hasNext()) {
            Class<?> allowedPeer = it.next();
            if (peer == null && allowedPeer == null) {
                validPeer = true;
                continue;
            }
            if (allowedPeer == null || !allowedPeer.isInstance(peer)) continue;
            validPeer = true;
        }
        if (!validPeer) {
            throw new SAXParseException("<" + localName + "> is after an invalid element: " + Handler.class.getName(), this.getLocator());
        }
        if (nodeClass != null && !allowNesting) {
            it = this.parents.iterator();
            while (!invalidNesting && it.hasNext()) {
                if (!nodeClass.isInstance(it.next())) continue;
                invalidNesting = true;
            }
        }
        if (invalidNesting) {
            throw new SAXParseException("<" + localName + ">  may not be nested", this.getLocator());
        }
    }

    public void startElementBuilder(String tagName, Attributes attrs) {
        this.attrs = attrs;
        this.characters = new StringBuilder();
        Element element = this.document.createElement(tagName);
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            element.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
        }
        if (this.configurationStack.isEmpty()) {
            this.configurationStack.addLast(element);
        } else {
            ((Element)this.configurationStack.getLast()).appendChild(element);
            this.configurationStack.addLast(element);
        }
    }

    Handler getHandler(String uri, String localName) {
        SemanticModule module = this.modules.getSemanticModule(uri);
        if (module != null) {
            return module.getHandler(localName);
        }
        return null;
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        if (this.characters != null) {
            this.characters.append(chars, start, len);
        }
    }

    public Element endElementBuilder() {
        Element element = (Element)this.configurationStack.removeLast();
        if (this.characters != null) {
            element.appendChild(this.document.createTextNode(this.characters.toString()));
        }
        this.characters = null;
        return element;
    }

    public Object getParent() {
        try {
            return this.parents.size() > 0 ? this.parents.getLast() : null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public SAXParser getParser() {
        return this.parser;
    }

    public Object getParent(int index) {
        ListIterator it = this.parents.listIterator(this.parents.size());
        int x = 0;
        Object parent = null;
        while (x++ <= index) {
            parent = it.previous();
        }
        return parent;
    }

    public Object removeParent() {
        Object parent = this.parents.removeLast();
        return parent;
    }

    public LinkedList getParents() {
        return this.parents;
    }

    public Object getParent(Class parent) {
        ListIterator it = this.parents.listIterator(this.parents.size());
        Object node = null;
        while (it.hasPrevious() && !parent.isInstance(node = it.previous())) {
        }
        return node;
    }

    public Object getPeer() {
        return this.peer;
    }

    public Object getCurrent() {
        return this.current;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            InputSource inputSource = this.resolveSchema(publicId, systemId);
            if (inputSource != null) {
                return inputSource;
            }
            if (this.entityResolver != null) {
                return this.entityResolver.resolveEntity(publicId, systemId);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.namespaces.remove(prefix);
    }

    protected String buildPrintMessage(SAXParseException x) {
        return this.message.format(new Object[]{x.getSystemId(), new Integer(x.getLineNumber()), new Integer(x.getColumnNumber()), x.getMessage()});
    }

    @Override
    public void warning(SAXParseException x) {
        logger.warn(this.buildPrintMessage(x));
    }

    @Override
    public void error(SAXParseException x) {
        logger.error(this.buildPrintMessage(x));
    }

    @Override
    public void fatalError(SAXParseException x) throws SAXParseException {
        logger.error(this.buildPrintMessage(x));
        throw x;
    }

    private InputSource resolveSchema(String publicId, String systemId) throws SAXException, IOException {
        if (!systemId.toLowerCase().endsWith("xsd")) {
            return null;
        }
        try {
            if (this.getTimeout() >= 0) {
                URL url = new URL(systemId);
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(this.getTimeout());
                return new InputSource(conn.getInputStream());
            }
        }
        catch (Exception url) {
            // empty catch block
        }
        int index = systemId.lastIndexOf("/");
        if (index == -1) {
            index = systemId.lastIndexOf("\\");
        }
        String xsd = index != -1 ? systemId.substring(index + 1) : systemId;
        InputStream is = ExtensibleXmlParser.class.getResourceAsStream("/" + xsd);
        if (is != null) {
            return new InputSource(is);
        }
        is = ExtensibleXmlParser.class.getResourceAsStream("/META-INF/" + xsd);
        if (is != null) {
            return new InputSource(is);
        }
        is = ExtensibleXmlParser.class.getResourceAsStream("META-INF/" + xsd);
        if (is != null) {
            return new InputSource(is);
        }
        File file = new File(xsd);
        if (file.exists()) {
            return new InputSource(new BufferedInputStream(new FileInputStream(file)));
        }
        return null;
    }

    private void initEntityResolver() {
        String entityResolveClazzName = System.getProperty(ENTITY_RESOLVER_PROPERTY_NAME);
        if (entityResolveClazzName != null && entityResolveClazzName.length() > 0) {
            try {
                Class<?> entityResolverClazz = this.classLoader.loadClass(entityResolveClazzName);
                this.entityResolver = (EntityResolver)entityResolverClazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Attributes getAttrs() {
        return this.attrs;
    }

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }

    public Object getNamespaceURI(String namespace) {
        return this.namespaces.get(namespace);
    }

    public static class Null {
        public static final Null instance = new Null();
    }
}

