/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableBigDecimalScoreHolder
extends AbstractScoreHolder {
    private BigDecimal[] hardScores;
    private BigDecimal[] softScores;

    public BendableBigDecimalScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled, BendableBigDecimalScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public BigDecimal getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public BigDecimal getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, BigDecimal weight) {
        this.hardScores[hardLevel] = this.hardScores[hardLevel].add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScores[hardLevel] = this.hardScores[hardLevel].subtract(weight);
        }, () -> {
            Object[] newHardScores = new BigDecimal[this.hardScores.length];
            Arrays.fill(newHardScores, BigDecimal.ZERO);
            Object[] newSoftScores = new BigDecimal[this.softScores.length];
            Arrays.fill(newSoftScores, BigDecimal.ZERO);
            newHardScores[hardLevel] = weight;
            return BendableBigDecimalScore.valueOf((BigDecimal[])newHardScores, (BigDecimal[])newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, BigDecimal weight) {
        this.softScores[softLevel] = this.softScores[softLevel].add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScores[softLevel] = this.softScores[softLevel].subtract(weight);
        }, () -> {
            Object[] newHardScores = new BigDecimal[this.hardScores.length];
            Arrays.fill(newHardScores, BigDecimal.ZERO);
            Object[] newSoftScores = new BigDecimal[this.softScores.length];
            Arrays.fill(newSoftScores, BigDecimal.ZERO);
            newSoftScores[softLevel] = weight;
            return BendableBigDecimalScore.valueOf((BigDecimal[])newHardScores, (BigDecimal[])newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal[] hardWeights, BigDecimal[] softWeights) {
        int i;
        if (this.hardScores.length != hardWeights.length) {
            throw new IllegalArgumentException("The hardScores length (" + this.hardScores.length + ") is different than the hardWeights length (" + hardWeights.length + ").");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            this.hardScores[i] = this.hardScores[i].add(hardWeights[i]);
        }
        if (this.softScores.length != softWeights.length) {
            throw new IllegalArgumentException("The softScores length (" + this.softScores.length + ") is different than the softWeights length (" + softWeights.length + ").");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            this.softScores[i] = this.softScores[i].add(softWeights[i]);
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                this.hardScores[i] = this.hardScores[i].subtract(hardWeights[i]);
            }
            for (i = 0; i < this.softScores.length; ++i) {
                this.softScores[i] = this.softScores[i].subtract(softWeights[i]);
            }
        }, () -> BendableBigDecimalScore.valueOf(hardWeights, softWeights));
    }

    @Override
    public Score extractScore(int initScore) {
        return new BendableBigDecimalScore(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

