/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.impl.domain.common.AlphabeticMemberComparator;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;

public class ConfigUtils {
    private static final AlphabeticMemberComparator alphabeticMemberComparator = new AlphabeticMemberComparator();
    public static final String AVAILABLE_PROCESSOR_COUNT = "availableProcessorCount";

    public static <T> T newInstance(Object bean, String propertyName, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("The " + bean.getClass().getSimpleName() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor" + ((clazz.isLocalClass() || clazz.isAnonymousClass() || clazz.isMemberClass()) && !Modifier.isStatic(clazz.getModifiers()) ? " because it is an inner class." : "."), e);
        }
    }

    public static void applyCustomProperties(Object bean, String wrappingPropertyName, Map<String, String> customProperties) {
        if (customProperties == null) {
            return;
        }
        Class<?> beanClass = bean.getClass();
        customProperties.forEach((propertyName, valueString) -> {
            Object typedValue;
            Method setterMethod;
            block12: {
                setterMethod = ReflectionHelper.getSetterMethod(beanClass, propertyName);
                if (setterMethod == null) {
                    throw new IllegalStateException("The customProperty (" + propertyName + ") with value (" + valueString + ") cannot be set on class (" + beanClass + ") because it has no public setter for that property.\nMaybe add a public setter for that customProperty (" + propertyName + ") on that class (" + beanClass.getSimpleName() + ").");
                }
                Class<?> propertyType = setterMethod.getParameterTypes()[0];
                try {
                    if (propertyType.equals(String.class)) {
                        typedValue = valueString;
                        break block12;
                    }
                    if (propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)) {
                        typedValue = Boolean.parseBoolean(valueString);
                        break block12;
                    }
                    if (propertyType.equals(Integer.TYPE) || propertyType.equals(Integer.class)) {
                        typedValue = Integer.parseInt(valueString);
                        break block12;
                    }
                    if (propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)) {
                        typedValue = Long.parseLong(valueString);
                        break block12;
                    }
                    if (propertyType.equals(Float.TYPE) || propertyType.equals(Float.class)) {
                        typedValue = Float.valueOf(Float.parseFloat(valueString));
                        break block12;
                    }
                    if (propertyType.equals(Double.TYPE) || propertyType.equals(Double.class)) {
                        typedValue = Double.parseDouble(valueString);
                        break block12;
                    }
                    throw new IllegalStateException("The customProperty (" + propertyName + ") of class (" + beanClass + ") has an unsupported propertyType (" + propertyType + ") for value (" + valueString + ").");
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("The customProperty (" + propertyName + ")'s value (" + valueString + ") cannot be parsed to the propertyType (" + propertyType + ") of the setterMethod (" + setterMethod + ").");
                }
            }
            try {
                setterMethod.invoke(bean, typedValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot call property (" + propertyName + ") setterMethod (" + setterMethod + ") on bean of class (" + bean.getClass() + ") for value (" + typedValue + ").", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("The property (" + propertyName + ") setterMethod (" + setterMethod + ") on bean of class (" + bean.getClass() + ") throws an exception for value (" + typedValue + ").", e.getCause());
            }
        });
    }

    public static <C extends AbstractConfig<C>> C inheritConfig(C original, C inherited) {
        if (inherited != null) {
            if (original == null) {
                original = inherited.copyConfig();
            } else {
                original.inherit(inherited);
            }
        }
        return original;
    }

    public static <C extends AbstractConfig<C>> List<C> inheritMergeableListConfig(List<C> originalList, List<C> inheritedList) {
        if (inheritedList != null) {
            ArrayList<C> mergedList = new ArrayList<C>(inheritedList.size() + (originalList == null ? 0 : originalList.size()));
            for (AbstractConfig inherited : inheritedList) {
                Object copy = inherited.copyConfig();
                mergedList.add(copy);
            }
            if (originalList != null) {
                mergedList.addAll(originalList);
            }
            originalList = mergedList;
        }
        return originalList;
    }

    public static <T> T inheritOverwritableProperty(T original, T inherited) {
        if (original != null) {
            return original;
        }
        return inherited;
    }

    public static <T> List<T> inheritMergeableListProperty(List<T> originalList, List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return new ArrayList<T>(inheritedList);
        }
        ArrayList<T> mergedList = new ArrayList<T>(inheritedList);
        mergedList.addAll(originalList);
        return mergedList;
    }

    public static <K, T> Map<K, T> inheritMergeableMapProperty(Map<K, T> originalMap, Map<K, T> inheritedMap) {
        if (inheritedMap == null) {
            return originalMap;
        }
        if (originalMap == null) {
            return inheritedMap;
        }
        LinkedHashMap<K, T> mergedMap = new LinkedHashMap<K, T>(inheritedMap);
        mergedMap.putAll(originalMap);
        return mergedMap;
    }

    public static <T> T mergeProperty(T a, T b) {
        return (T)(Objects.equals(a, b) ? a : null);
    }

    public static <T> T meldProperty(T a, T b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        return ConfigUtils.mergeProperty(a, b);
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int ceilDivide(int dividend, int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0 ? 0 : (Integer.signum(dividend) * Integer.signum(divisor) < 0 ? 0 : 1);
        return dividend / divisor + correction;
    }

    public static int resolveThreadPoolSizeScript(String propertyName, String script, String ... magicValues) {
        Object scriptResult;
        String scriptLanguage = "JavaScript";
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        scriptEngine.put(AVAILABLE_PROCESSOR_COUNT, Runtime.getRuntime().availableProcessors());
        try {
            scriptResult = scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("The " + propertyName + " (" + script + ") is not in magicValues (" + Arrays.toString(magicValues) + ") and cannot be parsed in " + "JavaScript" + " with the variables ([" + AVAILABLE_PROCESSOR_COUNT + "]).", e);
        }
        if (!(scriptResult instanceof Number)) {
            throw new IllegalArgumentException("The " + propertyName + " (" + script + ") is resolved to scriptResult (" + scriptResult + ") in " + "JavaScript" + " but is not a " + Number.class.getSimpleName() + ".");
        }
        return ((Number)scriptResult).intValue();
    }

    public static List<Class<?>> getAllAnnotatedLineageClasses(Class<?> bottomClass, Class<? extends Annotation> annotation) {
        if (!bottomClass.isAnnotationPresent(annotation)) {
            return Collections.emptyList();
        }
        ArrayList lineageClassList = new ArrayList();
        lineageClassList.add(bottomClass);
        Class<?> superclass = bottomClass.getSuperclass();
        lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superclass, annotation));
        for (Class<?> superInterface : bottomClass.getInterfaces()) {
            lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superInterface, annotation));
        }
        return lineageClassList;
    }

    public static List<Member> getDeclaredMembers(Class<?> baseClass) {
        Stream<Field> fieldStream = Stream.of(baseClass.getDeclaredFields()).sorted(alphabeticMemberComparator);
        Stream<Method> methodStream = Stream.of(baseClass.getDeclaredMethods()).filter(method -> !method.isBridge()).sorted(alphabeticMemberComparator);
        return Stream.concat(fieldStream, methodStream).collect(Collectors.toList());
    }

    public static List<Member> getAllMembers(Class<?> baseClass, Class<? extends Annotation> annotationClass) {
        Stream<Object> memberStream = Stream.empty();
        for (Class<?> clazz = baseClass; clazz != null; clazz = clazz.getSuperclass()) {
            Stream<Field> fieldStream = Stream.of(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotationClass)).sorted(alphabeticMemberComparator);
            Stream<Method> methodStream = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotationClass)).sorted(alphabeticMemberComparator);
            memberStream = Stream.concat(memberStream, Stream.concat(fieldStream, methodStream));
        }
        return memberStream.collect(Collectors.toList());
    }

    @SafeVarargs
    public static Class<? extends Annotation> extractAnnotationClass(Member member, Class<? extends Annotation> ... annotations) {
        Class<? extends Annotation> annotationClass = null;
        for (Class<? extends Annotation> detectedAnnotationClass : annotations) {
            if (!((AnnotatedElement)((Object)member)).isAnnotationPresent(detectedAnnotationClass)) continue;
            if (annotationClass != null) {
                throw new IllegalStateException("The class (" + member.getDeclaringClass() + ") has a member (" + member + ") that has both a " + annotationClass.getSimpleName() + " annotation and a " + detectedAnnotationClass.getSimpleName() + " annotation.");
            }
            annotationClass = detectedAnnotationClass;
        }
        return annotationClass;
    }

    public static Class<?> extractCollectionGenericTypeParameter(String parentClassConcept, Class<?> parentClass, Class<?> type, Type genericType, Class<? extends Annotation> annotationClass, String memberName) {
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("The " + parentClassConcept + " (" + parentClass + ") has a " + (annotationClass == null ? "auto discovered" : annotationClass.getSimpleName() + " annotated") + " member (" + memberName + ") with a member type (" + type + ") that returns a " + Collection.class.getSimpleName() + " which has no generic parameters.\nMaybe the member (" + memberName + ") should return a typed " + Collection.class.getSimpleName() + ".");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException("The " + parentClassConcept + " (" + parentClass + ") has a " + (annotationClass == null ? "auto discovered" : annotationClass.getSimpleName() + " annotated") + " member (" + memberName + ") with a member type (" + type + ") which is parameterized collection with an unsupported number of generic parameters (" + typeArguments.length + ").");
        }
        Type typeArgument = typeArguments[0];
        if (typeArgument instanceof ParameterizedType) {
            typeArgument = ((ParameterizedType)typeArgument).getRawType();
        }
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("The " + parentClassConcept + " (" + parentClass + ") has a " + (annotationClass == null ? "auto discovered" : annotationClass.getSimpleName() + " annotated") + " member (" + memberName + ") with a member type (" + type + ") which is parameterized collection with an unsupported type argument (" + typeArgument + ").");
        }
        return (Class)typeArgument;
    }

    public static <C> MemberAccessor findPlanningIdMemberAccessor(Class<C> clazz) {
        List<Member> memberList = ConfigUtils.getAllMembers(clazz, PlanningId.class);
        if (memberList.isEmpty()) {
            return null;
        }
        if (memberList.size() > 1) {
            throw new IllegalArgumentException("The class (" + clazz + ") has " + memberList.size() + " members (" + memberList + ") with a " + PlanningId.class.getSimpleName() + " annotation.");
        }
        Member member = memberList.get(0);
        MemberAccessor memberAccessor = MemberAccessorFactory.buildMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningId.class);
        if (!Comparable.class.isAssignableFrom(memberAccessor.getType())) {
            throw new IllegalArgumentException("The class (" + clazz + ") has a member (" + member + ") with a " + PlanningId.class.getSimpleName() + " annotation that returns a type (" + memberAccessor.getType() + ") that does not implement " + Comparable.class.getSimpleName() + ".\nMaybe use an " + Integer.class.getSimpleName() + " or " + String.class.getSimpleName() + " type instead.");
        }
        return memberAccessor;
    }

    private ConfigUtils() {
    }
}

