/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.scope;

import java.util.Random;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class LocalSearchMoveScope<Solution_> {
    private final LocalSearchStepScope<Solution_> stepScope;
    private final int moveIndex;
    private final Move<Solution_> move;
    private Score score = null;
    private Boolean accepted = null;

    public LocalSearchMoveScope(LocalSearchStepScope<Solution_> stepScope, int moveIndex, Move<Solution_> move) {
        this.stepScope = stepScope;
        this.moveIndex = moveIndex;
        this.move = move;
    }

    public LocalSearchStepScope<Solution_> getStepScope() {
        return this.stepScope;
    }

    public int getMoveIndex() {
        return this.moveIndex;
    }

    public Move<Solution_> getMove() {
        return this.move;
    }

    public Score getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public Boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public InnerScoreDirector<Solution_> getScoreDirector() {
        return this.stepScope.getScoreDirector();
    }

    public Solution_ getWorkingSolution() {
        return this.stepScope.getWorkingSolution();
    }

    public Random getWorkingRandom() {
        return this.stepScope.getWorkingRandom();
    }

    public LocalSearchMoveScope<Solution_> rebase(LocalSearchStepScope<Solution_> destinationStepScope, InnerScoreDirector<Solution_> destinationScoreDirector) {
        if (this.stepScope.getStepIndex() != destinationStepScope.getStepIndex()) {
            throw new IllegalStateException("Impossible situation: rebasing of MoveScope with stepIndex (" + this.stepScope.getStepIndex() + ") and moveIndex (" + this.moveIndex + ") fails because the destinationStepScope has a different stepIndex (" + destinationStepScope.getStepIndex() + ").");
        }
        Move<Solution_> rebasedMove = this.move.rebase(destinationScoreDirector);
        LocalSearchMoveScope<Solution_> rebasedMoveScope = new LocalSearchMoveScope<Solution_>(destinationStepScope, this.moveIndex, rebasedMove);
        rebasedMoveScope.setScore(this.score);
        rebasedMoveScope.setAccepted(this.accepted);
        return rebasedMoveScope;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.stepScope.getStepIndex() + "/" + this.moveIndex + ")";
    }
}

