/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.rocktour.domain;

import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.rocktour.domain.RockBus;
import org.optaplanner.examples.rocktour.domain.RockShow;
import org.optaplanner.examples.rocktour.domain.RockTourParametrization;

@PlanningSolution
public class RockTourSolution
extends AbstractPersistable {
    private String tourName;
    @ProblemFactProperty
    private RockTourParametrization parametrization;
    @ProblemFactProperty
    private RockBus bus;
    @PlanningEntityCollectionProperty
    @ValueRangeProvider(id="showRange")
    private List<RockShow> showList;
    @PlanningScore
    private HardMediumSoftLongScore score = null;

    public RockTourSolution() {
    }

    public RockTourSolution(long id) {
        super(id);
    }

    @ValueRangeProvider(id="busRange")
    public List<RockBus> getBugRange() {
        return Collections.singletonList(this.bus);
    }

    public String getTourName() {
        return this.tourName;
    }

    public void setTourName(String tourName) {
        this.tourName = tourName;
    }

    public RockTourParametrization getParametrization() {
        return this.parametrization;
    }

    public void setParametrization(RockTourParametrization parametrization) {
        this.parametrization = parametrization;
    }

    public RockBus getBus() {
        return this.bus;
    }

    public void setBus(RockBus bus) {
        this.bus = bus;
    }

    public List<RockShow> getShowList() {
        return this.showList;
    }

    public void setShowList(List<RockShow> showList) {
        this.showList = showList;
    }

    public HardMediumSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardMediumSoftLongScore score) {
        this.score = score;
    }
}

