/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.solver;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusStop;
import org.optaplanner.examples.coachshuttlegathering.domain.Coach;
import org.optaplanner.examples.coachshuttlegathering.domain.Shuttle;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;

public class CoachShuttleGatheringConstraintProvider
implements ConstraintProvider {
    static final String CONSTRAINT_PACKAGE = "org.optaplanner.examples.coachshuttlegathering.solver";

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.coachStopLimit(constraintFactory), this.shuttleCapacity(constraintFactory), this.coachCapacity(constraintFactory), this.coachCapacityShuttleButNoShuttle(constraintFactory), this.coachCapacityCorrection(constraintFactory), this.transportTime(constraintFactory), this.shuttleDestinationIsCoachOrHub(constraintFactory), this.shuttleSetupCost(constraintFactory), this.distanceFromPrevious(constraintFactory), this.distanceBusStopToBusDestination(constraintFactory), this.distanceCoachDirectlyToDestination(constraintFactory)};
    }

    Constraint coachStopLimit(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Coach.class).join(BusStop.class, Joiners.equal(coach -> coach, BusStop::getBus)).groupBy((coach, busStop) -> coach, ConstraintCollectors.countBi()).filter((coach, stopCount) -> stopCount > coach.getStopLimit()).penalizeLong(CONSTRAINT_PACKAGE, "coachStopLimit", (Score)HardSoftLongScore.ONE_HARD, (coach, stopCount) -> (long)(stopCount - coach.getStopLimit()) * 1000000L);
    }

    Constraint shuttleCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Shuttle.class).filter(bus -> bus.getPassengerQuantityTotal() > bus.getCapacity()).penalizeLong(CONSTRAINT_PACKAGE, "shuttleCapacity", (Score)HardSoftLongScore.ONE_HARD, bus -> (long)(bus.getPassengerQuantityTotal() - bus.getCapacity()) * 1000L);
    }

    Constraint coachCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Coach.class).join(Shuttle.class).join(BusStop.class, Joiners.equal((coach, shuttle) -> shuttle.getDestination(), stop -> stop), Joiners.equal((coach, shuttle) -> coach, BusStop::getBus)).join(BusStop.class, Joiners.equal((coach, shuttle, stop) -> shuttle, BusStop::getBus)).groupBy((coach, shuttle, stop1, stop2) -> coach, ConstraintCollectors.sum((coach, shuttle, stop1, stop2) -> stop2.getPassengerQuantity())).filter((coach, shuttlePassengerQuantityTotal) -> coach.getPassengerQuantityTotal() + shuttlePassengerQuantityTotal > coach.getCapacity()).penalizeLong(CONSTRAINT_PACKAGE, "coachCapacity", (Score)HardSoftLongScore.ONE_HARD, (coach, shuttlePassengerQuantityTotal) -> (long)(coach.getPassengerQuantityTotal() + shuttlePassengerQuantityTotal - coach.getCapacity()) * 1000L);
    }

    Constraint coachCapacityCorrection(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Coach.class).join(Shuttle.class).join(BusStop.class, Joiners.equal((coach, shuttle) -> shuttle.getDestination(), stop -> stop), Joiners.equal((coach, shuttle) -> coach, BusStop::getBus)).join(BusStop.class, Joiners.equal((coach, shuttle, stop) -> shuttle, BusStop::getBus)).groupBy((coach, shuttle, stop1, stop2) -> coach, ConstraintCollectors.sum((coach, shuttle, stop1, stop2) -> stop2.getPassengerQuantity())).filter((coach, shuttlePassengerQuantityTotal) -> coach.getPassengerQuantityTotal() > coach.getCapacity()).rewardLong(CONSTRAINT_PACKAGE, "coachCapacityCorrection", (Score)HardSoftLongScore.ONE_HARD, (coach, shuttlePassengerQuantityTotal) -> (long)(coach.getPassengerQuantityTotal() - coach.getCapacity()) * 1000L);
    }

    Constraint coachCapacityShuttleButNoShuttle(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Coach.class).filter(coach -> coach.getPassengerQuantityTotal() > coach.getCapacity()).penalizeLong(CONSTRAINT_PACKAGE, "coachCapacityShuttleButNoShuttle", (Score)HardSoftLongScore.ONE_HARD, coach -> (long)(coach.getPassengerQuantityTotal() - coach.getCapacity()) * 1000L);
    }

    Constraint transportTime(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BusStop.class).filter(busStop -> busStop.getTransportTimeToHub() != null && busStop.getTransportTimeRemainder() < 0).penalizeLong(CONSTRAINT_PACKAGE, "transportTime", (Score)HardSoftLongScore.ONE_HARD, busStop -> -busStop.getTransportTimeRemainder().intValue());
    }

    Constraint shuttleDestinationIsCoachOrHub(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Shuttle.class).filter(shuttle -> shuttle.getDestination() != null).join(StopOrHub.class, Joiners.equal(Shuttle::getDestination, Function.identity())).filter((shuttle, stop) -> !stop.isVisitedByCoach()).penalizeLong(CONSTRAINT_PACKAGE, "shuttleDestinationIsCoachOrHub", (Score)HardSoftLongScore.ONE_HARD, (bus, stop) -> 1000000000L);
    }

    Constraint shuttleSetupCost(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Bus.class).filter(bus -> bus.getNextStop() != null).penalizeLong(CONSTRAINT_PACKAGE, "shuttleSetupCost", (Score)HardSoftLongScore.ONE_SOFT, Bus::getSetupCost);
    }

    Constraint distanceFromPrevious(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BusStop.class).filter(bus -> bus.getPreviousBusOrStop() != null).penalizeLong(CONSTRAINT_PACKAGE, "distanceFromPrevious", (Score)HardSoftLongScore.ONE_SOFT, BusStop::getDistanceFromPreviousCost);
    }

    Constraint distanceBusStopToBusDestination(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BusStop.class).filter(busStop -> busStop.getNextStop() == null).join(Bus.class, Joiners.equal(BusStop::getBus, Function.identity())).filter((busStop, bus) -> bus.getDestination() != null && bus.getNextStop() != null).penalizeLong(CONSTRAINT_PACKAGE, "distanceBusStopToBusDestination", (Score)HardSoftLongScore.ONE_SOFT, (busStop, bus) -> busStop.getDistanceToDestinationCost(bus.getDestination()));
    }

    Constraint distanceCoachDirectlyToDestination(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Coach.class).filter(coach -> coach.getDestination() != null && coach.getNextStop() == null).penalizeLong(CONSTRAINT_PACKAGE, "distanceCoachDirectlyToDestination", (Score)HardSoftLongScore.ONE_SOFT, Coach::getDistanceToDestinationCost);
    }
}

