/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablelong;

import java.util.Arrays;
import java.util.stream.LongStream;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreHolderImpl;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreInliner;
import org.optaplanner.core.impl.score.definition.AbstractBendableScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class BendableLongScoreDefinition
extends AbstractBendableScoreDefinition<BendableLongScore> {
    public BendableLongScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(hardLevelsSize, softLevelsSize);
    }

    @Override
    public Class<BendableLongScore> getScoreClass() {
        return BendableLongScore.class;
    }

    @Override
    public BendableLongScore getZeroScore() {
        return BendableLongScore.zero(this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public final BendableLongScore getOneSoftestScore() {
        return BendableLongScore.ofSoft(this.hardLevelsSize, this.softLevelsSize, this.softLevelsSize - 1, 1L);
    }

    @Override
    public BendableLongScore parseScore(String scoreString) {
        BendableLongScore score = BendableLongScore.parseScore(scoreString);
        if (score.getHardLevelsSize() != this.hardLevelsSize) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") for the scoreClass (" + BendableLongScore.class.getSimpleName() + ") doesn't follow the correct pattern: the hardLevelsSize (" + score.getHardLevelsSize() + ") doesn't match the scoreDefinition's hardLevelsSize (" + this.hardLevelsSize + ").");
        }
        if (score.getSoftLevelsSize() != this.softLevelsSize) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") for the scoreClass (" + BendableLongScore.class.getSimpleName() + ") doesn't follow the correct pattern: the softLevelsSize (" + score.getSoftLevelsSize() + ") doesn't match the scoreDefinition's softLevelsSize (" + this.softLevelsSize + ").");
        }
        return score;
    }

    @Override
    public BendableLongScore fromLevelNumbers(int initScore, Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = (Long)levelNumbers[i];
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = (Long)levelNumbers[this.hardLevelsSize + i];
        }
        return BendableLongScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public BendableLongScore createScore(long ... scores) {
        return this.createScoreUninitialized(0, scores);
    }

    public BendableLongScore createScoreUninitialized(int initScore, long ... scores) {
        int levelsSize = this.hardLevelsSize + this.softLevelsSize;
        if (scores.length != levelsSize) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelsSize (" + levelsSize + ").");
        }
        return BendableLongScore.ofUninitialized(initScore, Arrays.copyOfRange(scores, 0, this.hardLevelsSize), Arrays.copyOfRange(scores, this.hardLevelsSize, levelsSize));
    }

    public BendableLongScoreInliner buildScoreInliner(boolean constraintMatchEnabled) {
        return new BendableLongScoreInliner(constraintMatchEnabled, this.hardLevelsSize, this.softLevelsSize);
    }

    public BendableLongScoreHolderImpl buildScoreHolder(boolean constraintMatchEnabled) {
        return new BendableLongScoreHolderImpl(constraintMatchEnabled, this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public BendableLongScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableLongScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getHardScore(i) : Long.MAX_VALUE;
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getSoftScore(i) : Long.MAX_VALUE;
        }
        return BendableLongScore.ofUninitialized(0, hardScores, softScores);
    }

    @Override
    public BendableLongScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableLongScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_UP ? score.getHardScore(i) : Long.MIN_VALUE;
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = trendLevels[this.hardLevelsSize + i] == InitializingScoreTrendLevel.ONLY_UP ? score.getSoftScore(i) : Long.MIN_VALUE;
        }
        return BendableLongScore.ofUninitialized(0, hardScores, softScores);
    }

    @Override
    public BendableLongScore divideBySanitizedDivisor(BendableLongScore dividend, BendableLongScore divisor) {
        int dividendInitScore = dividend.getInitScore();
        int divisorInitScore = BendableLongScoreDefinition.sanitize(divisor.getInitScore());
        long[] hardScores = new long[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = BendableLongScoreDefinition.divide(dividend.getHardScore(i), BendableLongScoreDefinition.sanitize(divisor.getHardScore(i)));
        }
        long[] softScores = new long[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = BendableLongScoreDefinition.divide(dividend.getSoftScore(i), BendableLongScoreDefinition.sanitize(divisor.getSoftScore(i)));
        }
        long[] levels = LongStream.concat(Arrays.stream(hardScores), Arrays.stream(softScores)).toArray();
        return this.createScoreUninitialized(BendableLongScoreDefinition.divide(dividendInitScore, divisorInitScore), levels);
    }
}

