/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoftlong;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class HardMediumSoftLongScoreHolderImpl
extends AbstractScoreHolder<HardMediumSoftLongScore>
implements HardMediumSoftLongScoreHolder {
    protected final Map<Rule, BiConsumer<RuleContext, Long>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Long>>();
    protected final Map<Rule, BiConsumer<RuleContext, HardMediumSoftLongScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, HardMediumSoftLongScore>>();
    protected long hardScore;
    protected long mediumScore;
    protected long softScore;

    public HardMediumSoftLongScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftLongScore.ZERO);
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getMediumScore() {
        return this.mediumScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardMediumSoftLongScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, Long> matchExecutor = constraintWeight.equals(HardMediumSoftLongScore.ZERO) ? (kcontext, matchWeight) -> {} : (constraintWeight.getMediumScore() == 0L && constraintWeight.getSoftScore() == 0L ? (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * matchWeight) : (constraintWeight.getHardScore() == 0L && constraintWeight.getSoftScore() == 0L ? (kcontext, matchWeight) -> this.addMediumConstraintMatch((RuleContext)kcontext, constraintWeight.getMediumScore() * matchWeight) : (constraintWeight.getHardScore() == 0L && constraintWeight.getMediumScore() == 0L ? (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, constraintWeight.getSoftScore() * matchWeight) : (kcontext, matchWeight) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * matchWeight, constraintWeight.getMediumScore() * matchWeight, constraintWeight.getSoftScore() * matchWeight))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * weightMultiplier.getHardScore(), constraintWeight.getMediumScore() * weightMultiplier.getMediumScore(), constraintWeight.getSoftScore() * weightMultiplier.getSoftScore()));
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1L);
    }

    @Override
    public void penalize(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    @Override
    public void penalize(RuleContext kcontext, long hardWeightMultiplier, long mediumWeightMultiplier, long softWeightMultiplier) {
        this.impactScore(kcontext, -hardWeightMultiplier, -mediumWeightMultiplier, -softWeightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    @Override
    public void reward(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext, long hardWeightMultiplier, long mediumWeightMultiplier, long softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, (long)weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Long> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalizeLong().");
    }

    private void impactScore(RuleContext kcontext, long hardWeightMultiplier, long mediumWeightMultiplier, long softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, HardMediumSoftLongScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardMediumSoftLongScore.of(hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier));
    }

    @Override
    public void addHardConstraintMatch(RuleContext kcontext, long hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardMediumSoftLongScore.of(hardWeight, 0L, 0L));
    }

    @Override
    public void addMediumConstraintMatch(RuleContext kcontext, long mediumWeight) {
        this.mediumScore += mediumWeight;
        this.registerConstraintMatch(kcontext, () -> this.mediumScore -= mediumWeight, () -> HardMediumSoftLongScore.of(0L, mediumWeight, 0L));
    }

    @Override
    public void addSoftConstraintMatch(RuleContext kcontext, long softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardMediumSoftLongScore.of(0L, 0L, softWeight));
    }

    @Override
    public void addMultiConstraintMatch(RuleContext kcontext, long hardWeight, long mediumWeight, long softWeight) {
        this.hardScore += hardWeight;
        this.mediumScore += mediumWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.mediumScore -= mediumWeight;
            this.softScore -= softWeight;
        }, () -> HardMediumSoftLongScore.of(hardWeight, mediumWeight, softWeight));
    }

    @Override
    public HardMediumSoftLongScore extractScore(int initScore) {
        return HardMediumSoftLongScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }
}

