/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.impl.score.stream.drools.common.ConstraintSubTree;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactoryImpl;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ChildNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNodeType;

final class ConstraintTree<Node_ extends ConstraintGraphNode, Consequence_ extends ConstraintConsequence<Node_>> {
    private final ConstraintSubTree nestedNodes;
    private final DroolsVariableFactory variableFactory = new DroolsVariableFactoryImpl();

    ConstraintTree(Consequence_ consequence) {
        List<ConstraintGraphNode> orderedNodeList = this.orderNodes(consequence);
        this.nestedNodes = this.assembleSubTree(orderedNodeList);
        ConstraintGraphNode firstNode = orderedNodeList.get(0);
        if (firstNode.getType() != ConstraintGraphNodeType.FROM) {
            throw new IllegalStateException("Impossible state: First node (" + firstNode + ") is not " + (Object)((Object)ConstraintGraphNodeType.FROM) + " (" + (Object)((Object)firstNode.getType()) + ").");
        }
        ConstraintGraphNode lastNode = orderedNodeList.get(orderedNodeList.size() - 1);
        if (lastNode != consequence.getTerminalNode()) {
            throw new IllegalStateException("Impossible state: Last node (" + lastNode + ") is not terminal (" + consequence.getTerminalNode() + ").");
        }
    }

    private List<ConstraintGraphNode> orderNodes(Consequence_ consequence) {
        ArrayList<ConstraintGraphNode> nodeList = new ArrayList<ConstraintGraphNode>(0);
        ArrayDeque<Object> unprocessedNodeDeque = new ArrayDeque<Object>(0);
        unprocessedNodeDeque.add(consequence.getTerminalNode());
        while (!unprocessedNodeDeque.isEmpty()) {
            ConstraintGraphNode node = (ConstraintGraphNode)unprocessedNodeDeque.pollLast();
            nodeList.add(node);
            if (!(node instanceof ChildNode)) continue;
            List<ConstraintGraphNode> parentNodes = ((ChildNode)((Object)node)).getParentNodes();
            int parentNodeCount = parentNodes.size();
            if (parentNodeCount == 2) {
                ConstraintGraphNode supposedLeftParent = parentNodes.get(0);
                ConstraintGraphNode supposedRightParent = parentNodes.get(1);
                if (supposedLeftParent.getCardinality() < supposedRightParent.getCardinality()) {
                    throw new IllegalStateException("Impossible state: Left join parent (" + supposedLeftParent + ") has lower cardinality (" + supposedLeftParent.getCardinality() + ") than right (" + supposedRightParent + ", " + supposedRightParent.getCardinality() + ")");
                }
                unprocessedNodeDeque.add(supposedLeftParent);
                unprocessedNodeDeque.add(supposedRightParent);
                continue;
            }
            if (parentNodeCount == 1) {
                unprocessedNodeDeque.add(parentNodes.get(0));
                continue;
            }
            throw new IllegalStateException("Impossible state: Node (" + node + ") with wrong number of parents (" + parentNodeCount + ").");
        }
        Collections.reverse(nodeList);
        return Collections.unmodifiableList(nodeList);
    }

    public ConstraintSubTree getNestedNodes() {
        return this.nestedNodes;
    }

    private ConstraintSubTree assembleSubTree(List<ConstraintGraphNode> orderedNodeList) {
        List sequentialChunkList = new ArrayList(0);
        ArrayList<ConstraintGraphNode> unincludedNodeList = new ArrayList<ConstraintGraphNode>(0);
        for (ConstraintGraphNode node : orderedNodeList) {
            if (!(node.getType() != ConstraintGraphNodeType.FROM && node.getType() != ConstraintGraphNodeType.JOIN || unincludedNodeList.isEmpty())) {
                sequentialChunkList.add(unincludedNodeList);
                unincludedNodeList = new ArrayList(0);
            }
            unincludedNodeList.add(node);
        }
        if (!unincludedNodeList.isEmpty()) {
            sequentialChunkList.add(unincludedNodeList);
        }
        ConstraintSubTree joinSubTree = null;
        while (!sequentialChunkList.isEmpty()) {
            int chunkCount = sequentialChunkList.size();
            if (joinSubTree == null) {
                switch (chunkCount) {
                    case 2: {
                        throw new IllegalStateException("Impossible state: Must have at least three chunks (FROM, FROM, JOIN), but had " + sequentialChunkList + ".");
                    }
                    case 1: {
                        return new ConstraintSubTree((List)sequentialChunkList.get(0), this.variableFactory);
                    }
                }
                List currentChunkList = (List)sequentialChunkList.get(2);
                ConstraintSubTree leftSubTree = new ConstraintSubTree((List)sequentialChunkList.get(0), this.variableFactory);
                ConstraintSubTree rightSubTree = new ConstraintSubTree((List)sequentialChunkList.get(1), this.variableFactory);
                joinSubTree = new ConstraintSubTree(leftSubTree, rightSubTree, currentChunkList, this.variableFactory);
                sequentialChunkList = sequentialChunkList.subList(3, sequentialChunkList.size());
                continue;
            }
            if (chunkCount == 1) {
                throw new IllegalStateException("Impossible state: JOIN must have at least two follow-up chunks (FROM, JOIN), but had " + sequentialChunkList + ".");
            }
            ConstraintSubTree rightSubTree = new ConstraintSubTree((List)sequentialChunkList.get(0), this.variableFactory);
            joinSubTree = new ConstraintSubTree(joinSubTree, rightSubTree, (List)sequentialChunkList.get(1), this.variableFactory);
            sequentialChunkList = sequentialChunkList.subList(2, sequentialChunkList.size());
        }
        return joinSubTree;
    }
}

