/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.util.Arrays;
import org.drools.model.DSL;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate5;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.Mutator;
import org.optaplanner.core.impl.score.stream.penta.AbstractPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.FilteringPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.NonePentaJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

final class QuadExistenceMutator<A, B, C, D, E>
implements Mutator {
    private final boolean shouldExist;
    private final Class<E> otherFactType;
    private final AbstractPentaJoiner<A, B, C, D, E>[] joiners;

    public QuadExistenceMutator(AbstractConstraintModelJoiningNode<E, AbstractPentaJoiner<A, B, C, D, E>> node, boolean shouldExist) {
        this.shouldExist = shouldExist;
        this.otherFactType = node.getOtherFactType();
        this.joiners = (AbstractPentaJoiner[])node.get().stream().toArray(AbstractPentaJoiner[]::new);
    }

    private AbstractRuleAssembler applyJoiners(AbstractRuleAssembler ruleAssembler, AbstractPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> predicate) {
        if (joiner == null) {
            return this.applyFilters(ruleAssembler, predicate);
        }
        PentaPredicate<Object, Object, Object, Object, Object> joinFilter = joiner::matches;
        PentaPredicate<Object, Object, Object, Object, Object> result = predicate == null ? joinFilter : joinFilter.and(predicate);
        return this.applyFilters(ruleAssembler, result);
    }

    private AbstractRuleAssembler applyFilters(AbstractRuleAssembler ruleAssembler, PentaPredicate<A, B, C, D, E> predicate) {
        Variable<E> toExist = ruleAssembler.createVariable(this.otherFactType, "quadToExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, ruleAssembler.getVariable(0), ruleAssembler.getVariable(1), ruleAssembler.getVariable(2), ruleAssembler.getVariable(3), (Predicate5 & Serializable)(e, a, b, c, d) -> predicate.test(a, b, c, d, e));
        ExprViewItem existenceExpression = DSL.exists((ViewItemBuilder)possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!this.shouldExist) {
            existenceExpression = DSL.not((ViewItemBuilder)possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        ruleAssembler.addDependentExpressionToLastPattern((ViewItem)existenceExpression);
        return ruleAssembler;
    }

    @Override
    public AbstractRuleAssembler apply(AbstractRuleAssembler ruleAssembler) {
        int indexOfFirstFilter = -1;
        AbstractPentaJoiner<A, B, C, D, E> finalJoiner = null;
        PentaPredicate<A, B, C, D, E> finalFilter = null;
        for (int i = 0; i < this.joiners.length; ++i) {
            boolean hasAFilter;
            AbstractPentaJoiner<A, B, C, D, E> joiner = this.joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NonePentaJoiner && this.joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(this.joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringPentaJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + this.joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractPentaJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(ruleAssembler, finalJoiner, finalFilter);
    }
}

