/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.builder;

import java.util.ArrayList;
import java.util.List;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.ResourceChange;

public class ResourceChangeSet {
    private final String resourceName;
    private final ChangeType status;
    private final List<ResourceChange> changes = new ArrayList<ResourceChange>();
    private List<RuleLoadOrder> loadOrder = new ArrayList<RuleLoadOrder>();

    public ResourceChangeSet(String resourceName, ChangeType status) {
        this.resourceName = resourceName;
        this.status = status;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ChangeType getChangeType() {
        return this.status;
    }

    public List<ResourceChange> getChanges() {
        return this.changes;
    }

    public List<RuleLoadOrder> getLoadOrder() {
        return this.loadOrder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.changes.hashCode();
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceChangeSet other = (ResourceChangeSet)obj;
        if (!this.changes.equals(other.changes)) {
            return false;
        }
        if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
            return false;
        }
        return this.status == other.status;
    }

    public static class RuleLoadOrder {
        private String pkgName;
        private String ruleName;
        private int loadOrder;

        public RuleLoadOrder(String pkgName, String ruleName, int loadOrder) {
            this.pkgName = pkgName;
            this.ruleName = ruleName;
            this.loadOrder = loadOrder;
        }

        public String getPkgName() {
            return this.pkgName;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public int getLoadOrder() {
            return this.loadOrder;
        }
    }
}

