/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import org.kie.kogito.event.EventManager;
import org.kie.kogito.services.event.impl.BaseEventManager;
import org.kie.kogito.services.uow.ManagedUnitOfWork;
import org.kie.kogito.services.uow.PassThroughUnitOfWork;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;

public class DefaultUnitOfWorkManager
implements UnitOfWorkManager {
    private ThreadLocal<UnitOfWork> currentUnitOfWork = new ThreadLocal();
    private UnitOfWork fallbackUnitOfWork = new PassThroughUnitOfWork();
    private UnitOfWorkFactory factory;
    private EventManager eventManager = new BaseEventManager();

    public DefaultUnitOfWorkManager(UnitOfWorkFactory factory) {
        this.factory = factory;
    }

    public DefaultUnitOfWorkManager(UnitOfWork fallbackUnitOfWork, UnitOfWorkFactory factory) {
        this.fallbackUnitOfWork = fallbackUnitOfWork;
        this.factory = factory;
    }

    public UnitOfWork currentUnitOfWork() {
        UnitOfWork unit = this.currentUnitOfWork.get();
        if (unit == null) {
            return this.fallbackUnitOfWork;
        }
        return unit;
    }

    public UnitOfWork newUnitOfWork() {
        return new ManagedUnitOfWork(this.factory.create(this.eventManager), this::associate, this::dissociate, this::dissociate);
    }

    protected void associate(UnitOfWork unit) {
        this.currentUnitOfWork.set(unit);
    }

    protected void dissociate(UnitOfWork unit) {
        this.currentUnitOfWork.set(null);
    }

    public EventManager eventManager() {
        return this.eventManager;
    }
}

