/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftlong;

import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;

public final class HardMediumSoftLongScore
extends AbstractScore<HardMediumSoftLongScore> {
    public static final HardMediumSoftLongScore ZERO = new HardMediumSoftLongScore(0, 0L, 0L, 0L);
    public static final HardMediumSoftLongScore ONE_HARD = new HardMediumSoftLongScore(0, 1L, 0L, 0L);
    public static final HardMediumSoftLongScore ONE_MEDIUM = new HardMediumSoftLongScore(0, 0L, 1L, 0L);
    public static final HardMediumSoftLongScore ONE_SOFT = new HardMediumSoftLongScore(0, 0L, 0L, 1L);
    private static final String HARD_LABEL = "hard";
    private static final String MEDIUM_LABEL = "medium";
    private static final String SOFT_LABEL = "soft";
    private final long hardScore;
    private final long mediumScore;
    private final long softScore;

    public static HardMediumSoftLongScore parseScore(String scoreString) {
        String[] scoreTokens = HardMediumSoftLongScore.parseScoreTokens(HardMediumSoftLongScore.class, scoreString, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
        int initScore = HardMediumSoftLongScore.parseInitScore(HardMediumSoftLongScore.class, scoreString, scoreTokens[0]);
        long hardScore = HardMediumSoftLongScore.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, scoreTokens[1]);
        long mediumScore = HardMediumSoftLongScore.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, scoreTokens[2]);
        long softScore = HardMediumSoftLongScore.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftLongScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftLongScore ofUninitialized(int initScore, long hardScore, long mediumScore, long softScore) {
        return new HardMediumSoftLongScore(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftLongScore of(long hardScore, long mediumScore, long softScore) {
        return new HardMediumSoftLongScore(0, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftLongScore ofHard(long hardScore) {
        return new HardMediumSoftLongScore(0, hardScore, 0L, 0L);
    }

    public static HardMediumSoftLongScore ofMedium(long mediumScore) {
        return new HardMediumSoftLongScore(0, 0L, mediumScore, 0L);
    }

    public static HardMediumSoftLongScore ofSoft(long softScore) {
        return new HardMediumSoftLongScore(0, 0L, 0L, softScore);
    }

    private HardMediumSoftLongScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = Long.MIN_VALUE;
        this.mediumScore = Long.MIN_VALUE;
        this.softScore = Long.MIN_VALUE;
    }

    private HardMediumSoftLongScore(int initScore, long hardScore, long mediumScore, long softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getMediumScore() {
        return this.mediumScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardMediumSoftLongScore withInitScore(int newInitScore) {
        return new HardMediumSoftLongScore(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0L;
    }

    @Override
    public HardMediumSoftLongScore add(HardMediumSoftLongScore addend) {
        return new HardMediumSoftLongScore(this.initScore + addend.getInitScore(), this.hardScore + addend.getHardScore(), this.mediumScore + addend.getMediumScore(), this.softScore + addend.getSoftScore());
    }

    @Override
    public HardMediumSoftLongScore subtract(HardMediumSoftLongScore subtrahend) {
        return new HardMediumSoftLongScore(this.initScore - subtrahend.getInitScore(), this.hardScore - subtrahend.getHardScore(), this.mediumScore - subtrahend.getMediumScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardMediumSoftLongScore multiply(double multiplicand) {
        return new HardMediumSoftLongScore((int)Math.floor((double)this.initScore * multiplicand), (long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.mediumScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardMediumSoftLongScore divide(double divisor) {
        return new HardMediumSoftLongScore((int)Math.floor((double)this.initScore / divisor), (long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.mediumScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardMediumSoftLongScore power(double exponent) {
        return new HardMediumSoftLongScore((int)Math.floor(Math.pow(this.initScore, exponent)), (long)Math.floor(Math.pow(this.hardScore, exponent)), (long)Math.floor(Math.pow(this.mediumScore, exponent)), (long)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardMediumSoftLongScore negate() {
        return new HardMediumSoftLongScore(-this.initScore, -this.hardScore, -this.mediumScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftLongScore) {
            HardMediumSoftLongScore other = (HardMediumSoftLongScore)o;
            return this.initScore == other.getInitScore() && this.hardScore == other.getHardScore() && this.mediumScore == other.getMediumScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public int compareTo(HardMediumSoftLongScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        if (this.hardScore != other.getHardScore()) {
            return Long.compare(this.hardScore, other.getHardScore());
        }
        if (this.mediumScore != other.getMediumScore()) {
            return Long.compare(this.mediumScore, other.getMediumScore());
        }
        return Long.compare(this.softScore, other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> (Long)n != 0L, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + HARD_LABEL + "/" + this.mediumScore + MEDIUM_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

