/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;

public class ExternalizedSingletonInverseVariableSupply<Solution_>
implements SourcedVariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Object> inverseEntityMap = null;

    public ExternalizedSingletonInverseVariableSupply(VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        EntityDescriptor<Solution_> entityDescriptor = this.sourceVariableDescriptor.getEntityDescriptor();
        List<Object> entityList = entityDescriptor.extractEntities(scoreDirector.getWorkingSolution());
        this.inverseEntityMap = new IdentityHashMap<Object, Object>(entityList.size());
        for (Object entity : entityList) {
            this.insert(scoreDirector, entity);
        }
    }

    @Override
    public void close() {
        this.inverseEntityMap = null;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract(scoreDirector, entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.retract(scoreDirector, entity);
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    protected void insert(ScoreDirector<Solution_> scoreDirector, Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Object oldInverseEntity = this.inverseEntityMap.put(value, entity);
        if (oldInverseEntity != null) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be inserted: another entity (" + oldInverseEntity + ") already has that value (" + value + ").");
        }
    }

    protected void retract(ScoreDirector<Solution_> scoreDirector, Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Object oldInverseEntity = this.inverseEntityMap.remove(value);
        if (oldInverseEntity != entity) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be retracted: the entity was never inserted for that value (" + value + ").");
        }
    }

    @Override
    public Object getInverseSingleton(Object value) {
        return this.inverseEntityMap.get(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

