/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public final class NearEntityNearbyValueSelector<Solution_>
extends AbstractValueSelector<Solution_> {
    protected final ValueSelector<Solution_> childValueSelector;
    protected final EntitySelector<Solution_> replayingOriginEntitySelector;
    protected final NearbyDistanceMeter<?, ?> nearbyDistanceMeter;
    protected final NearbyRandom nearbyRandom;
    protected final boolean randomSelection;
    protected final boolean discardNearbyIndexZero;
    protected NearbyDistanceMatrix nearbyDistanceMatrix = null;

    public NearEntityNearbyValueSelector(ValueSelector<Solution_> childValueSelector, EntitySelector<Solution_> originEntitySelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childValueSelector = childValueSelector;
        if (!(originEntitySelector instanceof MimicReplayingEntitySelector)) {
            throw new IllegalStateException("Impossible state: Nearby value selector (" + this + ") did not receive a replaying entity selector (" + originEntitySelector + ").");
        }
        this.replayingOriginEntitySelector = originEntitySelector;
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        if (randomSelection && nearbyRandom == null) {
            throw new IllegalArgumentException("The valueSelector (" + this + ") with randomSelection (" + randomSelection + ") has no nearbyRandom (" + nearbyRandom + ").");
        }
        this.discardNearbyIndexZero = childValueSelector.getVariableDescriptor().getVariablePropertyType().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass());
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        this.phaseLifecycleSupport.addEventListener(originEntitySelector);
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        long originSize = this.replayingOriginEntitySelector.getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originEntitySelector (" + this.replayingOriginEntitySelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.nearbyDistanceMatrix = new NearbyDistanceMatrix(this.nearbyDistanceMeter, (int)originSize);
        Iterator<Object> originIt = this.replayingOriginEntitySelector.endingIterator();
        while (originIt.hasNext()) {
            Object origin = originIt.next();
            long childSize = this.childValueSelector.getSize(origin);
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The childEntitySelector (" + this.childValueSelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            int destinationSize = (int)childSize;
            if (this.randomSelection) {
                int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
                if (this.discardNearbyIndexZero && overallSizeMaximum < Integer.MAX_VALUE) {
                    ++overallSizeMaximum;
                }
                if (destinationSize > overallSizeMaximum) {
                    destinationSize = overallSizeMaximum;
                }
            }
            this.nearbyDistanceMatrix.addAllDestinations(origin, this.childValueSelector.endingIterator(origin), destinationSize);
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.nearbyDistanceMatrix = null;
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity) - (long)(this.discardNearbyIndexZero ? 1 : 0);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        Iterator<Object> replayingOriginEntityIterator = this.replayingOriginEntitySelector.iterator();
        if (!this.randomSelection) {
            return new OriginalEntityNearbyValueIterator(replayingOriginEntityIterator, this.childValueSelector.getSize(entity));
        }
        return new RandomEntityNearbyValueIterator(replayingOriginEntityIterator, this.childValueSelector.getSize(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.replayingOriginEntitySelector + ", " + this.childValueSelector + ")";
    }

    private final class RandomEntityNearbyValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> replayingOriginEntityIterator;
        private final int nearbySize;

        public RandomEntityNearbyValueIterator(Iterator<Object> replayingOriginEntityIterator, long childSize) {
            this.replayingOriginEntityIterator = replayingOriginEntityIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize - (NearEntityNearbyValueSelector.this.discardNearbyIndexZero ? 1 : 0);
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginEntityIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public Object next() {
            Object origin = this.replayingOriginEntityIterator.next();
            int nearbyIndex = NearEntityNearbyValueSelector.this.nearbyRandom.nextInt(NearEntityNearbyValueSelector.this.workingRandom, this.nearbySize);
            if (NearEntityNearbyValueSelector.this.discardNearbyIndexZero) {
                ++nearbyIndex;
            }
            return NearEntityNearbyValueSelector.this.nearbyDistanceMatrix.getDestination(origin, nearbyIndex);
        }
    }

    private final class OriginalEntityNearbyValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> replayingOriginEntityIterator;
        private final long childSize;
        private boolean originSelected = false;
        private boolean originIsNotEmpty;
        private Object origin;
        private int nextNearbyIndex;

        public OriginalEntityNearbyValueIterator(Iterator<Object> replayingOriginEntityIterator, long childSize) {
            this.replayingOriginEntityIterator = replayingOriginEntityIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = NearEntityNearbyValueSelector.this.discardNearbyIndexZero ? 1 : 0;
        }

        private void selectOrigin() {
            if (this.originSelected) {
                return;
            }
            this.originIsNotEmpty = this.replayingOriginEntityIterator.hasNext();
            this.origin = this.replayingOriginEntityIterator.next();
            this.originSelected = true;
        }

        @Override
        public boolean hasNext() {
            this.selectOrigin();
            return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public Object next() {
            this.selectOrigin();
            Object next = NearEntityNearbyValueSelector.this.nearbyDistanceMatrix.getDestination(this.origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return next;
        }
    }
}

