/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.function.Supplier;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.util.ScalablePool;

public class StatefulSessionPool {
    private final KnowledgeBaseImpl kbase;
    private final ScalablePool<StatefulKnowledgeSessionImpl> pool;

    public StatefulSessionPool(KnowledgeBaseImpl kbase, int initialSize, Supplier<StatefulKnowledgeSessionImpl> supplier) {
        this.kbase = kbase;
        this.pool = new ScalablePool<StatefulKnowledgeSessionImpl>(initialSize, supplier, s -> s.reset(), s -> s.fromPool(null).dispose());
    }

    public KnowledgeBaseImpl getKieBase() {
        return this.kbase;
    }

    public StatefulKnowledgeSessionImpl get() {
        return this.pool.get().fromPool(this);
    }

    public void release(StatefulKnowledgeSessionImpl session) {
        this.pool.release(session);
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

