/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablelong;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public final class BendableLongScoreInliner
extends ScoreInliner<BendableLongScore> {
    private final long[] hardScores;
    private final long[] softScores;

    public BendableLongScoreInliner(Map<Constraint, BendableLongScore> constraintToWeightMap, boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintToWeightMap, constraintMatchEnabled, BendableLongScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        BendableLongScore constraintWeight = (BendableLongScore)this.getConstraintWeight(constraint);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            long levelWeight = constraintWeight.getHardOrSoftScore(singleLevel);
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                    long hardImpact = levelWeight * matchWeight;
                    int n = level;
                    this.hardScores[n] = this.hardScores[n] + hardImpact;
                    UndoScoreImpacter undoScoreImpact = () -> {
                        int n = level;
                        this.hardScores[n] = this.hardScores[n] - hardImpact;
                    };
                    if (!this.constraintMatchEnabled) {
                        return undoScoreImpact;
                    }
                    Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableLongScore.ofHard(this.hardScores.length, this.softScores.length, level, hardImpact), (List)justificationsSupplier.get());
                    return () -> {
                        undoScoreImpact.run();
                        undoConstraintMatch.run();
                    };
                });
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                long softImpact = levelWeight * matchWeight;
                int n = level;
                this.softScores[n] = this.softScores[n] + softImpact;
                UndoScoreImpacter undoScoreImpact = () -> {
                    int n = level;
                    this.softScores[n] = this.softScores[n] - softImpact;
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableLongScore.ofSoft(this.hardScores.length, this.softScores.length, level, softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int i;
            long[] hardImpacts = new long[this.hardScores.length];
            long[] softImpacts = new long[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i) * matchWeight;
                int n = i;
                this.hardScores[n] = this.hardScores[n] + hardImpacts[i];
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i) * matchWeight;
                int n = i;
                this.softScores[n] = this.softScores[n] + softImpacts[i];
            }
            UndoScoreImpacter undoScoreImpact = () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    int n = i;
                    this.hardScores[n] = this.hardScores[n] - hardImpacts[i];
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    int n = i;
                    this.softScores[n] = this.softScores[n] - softImpacts[i];
                }
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableLongScore.of(hardImpacts, softImpacts), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public BendableLongScore extractScore(int initScore) {
        return BendableLongScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableLongScore.class.getSimpleName() + " inliner";
    }
}

