/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBridgeBiNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetJoinTriNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniNode;

public final class BavetJoinTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> leftParent;
    private final BavetAbstractUniConstraintStream<Solution_, C> rightParent;

    public BavetJoinTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> leftParent, BavetAbstractUniConstraintStream<Solution_, C> rightParent) {
        super(constraintFactory);
        this.leftParent = leftParent;
        this.rightParent = rightParent;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return Stream.concat(this.leftParent.getFromStreamList().stream(), this.rightParent.getFromStreamList().stream()).collect(Collectors.toList());
    }

    @Override
    public BavetJoinTriNode<A, B, C> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetJoinBridgeNode leftNode_, BavetJoinBridgeNode rightNode_) {
        BavetJoinBridgeBiNode leftNode = (BavetJoinBridgeBiNode)leftNode_;
        BavetJoinBridgeUniNode rightNode = (BavetJoinBridgeUniNode)rightNode_;
        BavetJoinTriNode node = new BavetJoinTriNode(buildPolicy.getSession(), buildPolicy.nextNodeIndex(), leftNode, rightNode);
        leftNode.setChildTupleRefresher(node::refreshChildTuplesLeft);
        rightNode.setChildTupleRefresher(node::refreshChildTuplesRight);
        node = (BavetJoinTriNode)this.processNode(buildPolicy, null, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, node);
        return node;
    }

    @Override
    protected BavetJoinTriNode<A, B, C> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractTriNode<A, B, C> parentNode) {
        throw new IllegalStateException("Impossible state: this code is never called.");
    }

    public String toString() {
        return "Join() with " + this.childStreamList.size() + " children";
    }
}

